<?php
// Quick test script - run via: php test_image_url.php

require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

echo "=== LOCALHOST IMAGE URL TEST ===\n\n";
echo "APP_URL: " . config('app.url') . "\n";
echo "Current directory: " . __DIR__ . "\n\n";

// Test Storage::url()
$testPath = 'products/test.jpg';
$url = Storage::disk('public')->url($testPath);
echo "Storage::url('$testPath'): $url\n\n";

// Test productImageUrl helper
if (function_exists('productImageUrl')) {
    echo "productImageUrl('$testPath'): " . productImageUrl($testPath) . "\n";
    
    // Test with actual product if exists
    try {
        $product = \App\Models\Product::whereNotNull('image')->first();
        if ($product) {
            echo "\nReal Product Test:\n";
            echo "DB Path: " . $product->image . "\n";
            echo "Generated URL: " . productImageUrl($product->image) . "\n";
        }
    } catch (\Exception $e) {
        echo "Error getting product: " . $e->getMessage() . "\n";
    }
} else {
    echo "ERROR: productImageUrl helper not found!\n";
}

echo "\n=== END TEST ===\n";

