<?php $__env->startSection('title', $product->name); ?>

<?php $__env->startSection('content'); ?>
<style>
    .product-image-container {
        position: relative;
    }
    .product-images-wrapper {
        position: relative;
        width: 100%;
        height: 100%;
        display: flex;
        transition: transform 0.5s ease-in-out;
    }
    .product-image {
        min-width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
    }
    .product-image-container:hover .product-images-wrapper {
        animation: slideImages 3s infinite;
    }
    @keyframes slideImages {
        0%, 20% {
            transform: translateX(0);
        }
        25%, 45% {
            transform: translateX(-100%);
        }
        50%, 70% {
            transform: translateX(-200%);
        }
        75%, 95% {
            transform: translateX(-300%);
        }
        100% {
            transform: translateX(0);
        }
    }
    .product-image-container[data-image-count="1"]:hover .product-images-wrapper {
        animation: none;
    }
    .product-image-container[data-image-count="2"]:hover .product-images-wrapper {
        animation: slideImages2 3s infinite;
    }
    @keyframes slideImages2 {
        0%, 45% {
            transform: translateX(0);
        }
        50%, 95% {
            transform: translateX(-100%);
        }
        100% {
            transform: translateX(0);
        }
    }
    .product-image-container[data-image-count="3"]:hover .product-images-wrapper {
        animation: slideImages3 4s infinite;
    }
    @keyframes slideImages3 {
        0%, 30% {
            transform: translateX(0);
        }
        33%, 63% {
            transform: translateX(-100%);
        }
        66%, 96% {
            transform: translateX(-200%);
        }
        100% {
            transform: translateX(0);
        }
    }
</style>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 p-8">
            <!-- Product Image -->
            <div>
                <div class="relative h-96 bg-gray-200 rounded-lg overflow-hidden mb-4">
                    <img id="mainProductImage" src="<?php echo e(productImageUrl($product->image)); ?>" alt="<?php echo e($product->name); ?>" class="w-full h-full object-cover"
                         onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                    <?php if($product->compare_price): ?>
                        <span class="absolute top-4 right-4 bg-red-500 text-white px-3 py-1 rounded text-sm font-semibold">
                            <?php echo e(round((($product->compare_price - $product->price) / $product->compare_price) * 100)); ?>% OFF
                        </span>
                    <?php endif; ?>
                </div>
                <?php if($product->images && count($product->images) > 0): ?>
                    <div class="grid grid-cols-4 gap-2">
                        <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <img src="<?php echo e(productImageUrl($image)); ?>" alt="<?php echo e($product->name); ?>" 
                                 class="w-full h-20 object-cover rounded cursor-pointer hover:opacity-75 transition"
                                 onclick="document.getElementById('mainProductImage').src = this.src;"
                                 onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Product Details -->
            <div>
                <h1 class="font-display text-4xl font-bold text-gray-900 mb-4"><?php echo e($product->name); ?></h1>
                <p class="text-gray-600 mb-4">
                    <a href="<?php echo e(route('products.index', ['category' => $product->category_id])); ?>" class="hover:text-primary transition">
                        <?php echo e($product->category->name); ?>

                    </a>
                </p>

                <div class="mb-6">
                    <div class="flex items-center gap-4 mb-4">
                        <span class="text-primary font-bold text-3xl"><?php echo e(currency($product->price)); ?></span>
                        <?php if($product->compare_price): ?>
                            <span class="text-gray-400 line-through text-xl"><?php echo e(currency($product->compare_price)); ?></span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="mb-6">
                    <p class="text-gray-700 leading-relaxed"><?php echo e($product->description); ?></p>
                </div>

                <?php if($product->short_description): ?>
                    <div class="mb-6">
                        <p class="text-gray-600"><?php echo e($product->short_description); ?></p>
                    </div>
                <?php endif; ?>

                <!-- Product Info -->
                <div class="mb-6 space-y-2">
                    <?php if($product->brand): ?>
                        <p class="text-sm text-gray-600"><span class="font-semibold">Brand:</span> <?php echo e($product->brand); ?></p>
                    <?php endif; ?>
                    <?php if($product->color): ?>
                        <p class="text-sm text-gray-600"><span class="font-semibold">Color:</span> <?php echo e($product->color); ?></p>
                    <?php endif; ?>
                    <?php if($product->size): ?>
                        <p class="text-sm text-gray-600"><span class="font-semibold">Size:</span> <?php echo e($product->size); ?></p>
                    <?php endif; ?>
                    <p class="text-sm text-gray-600"><span class="font-semibold">Stock:</span> <?php echo e($product->stock > 0 ? $product->stock . ' available' : 'Out of stock'); ?></p>
                </div>

                <!-- Add to Cart Form -->
                <?php if($product->stock > 0): ?>
                    <form action="<?php echo e(route('cart.store')); ?>" method="POST" class="mb-6 add-to-cart-form" id="addToCartForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                        
                        <div class="grid grid-cols-2 gap-4 mb-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Size</label>
                                <select name="size" id="product_size" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                                    <option value="">Select Size</option>
                                    <option value="XS">XS</option>
                                    <option value="S">S</option>
                                    <option value="M">M</option>
                                    <option value="L">L</option>
                                    <option value="XL">XL</option>
                                    <option value="XXL">XXL</option>
                                </select>
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Quantity</label>
                                <input type="number" name="quantity" id="product_quantity" value="1" min="1" max="<?php echo e($product->stock); ?>" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="block text-sm font-medium text-gray-700 mb-2">Color</label>
                            <input type="text" name="color" id="product_color" value="<?php echo e($product->color); ?>" placeholder="Color" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                        </div>

                        <div class="flex gap-4">
                            <button type="submit" class="flex-1 bg-primary text-white px-6 py-3 rounded-md text-lg font-semibold hover:bg-primary-dark transition">
                                Add to Cart
                            </button>
                            <button type="button" onclick="buyNow()" class="flex-1 bg-black text-white px-6 py-3 rounded-md text-lg font-semibold hover:bg-gray-800 transition">
                                Buy Now
                            </button>
                        </div>
                    </form>
                    <script>
                        function buyNow() {
                            const form = document.getElementById('addToCartForm');
                            
                            // Remove any existing buy_now input
                            const existingBuyNow = form.querySelector('input[name="buy_now"]');
                            if (existingBuyNow) {
                                existingBuyNow.remove();
                            }
                            
                            // Add buy_now parameter as hidden input
                            const buyNowInput = document.createElement('input');
                            buyNowInput.type = 'hidden';
                            buyNowInput.name = 'buy_now';
                            buyNowInput.value = '1';
                            form.appendChild(buyNowInput);
                            
                            // Submit form to cart store route, which will redirect to checkout
                            form.action = '<?php echo e(route('cart.store')); ?>';
                            form.method = 'POST';
                            form.submit();
                        }
                    </script>
                <?php else: ?>
                    <button disabled class="w-full bg-gray-400 text-white px-6 py-3 rounded-md text-lg font-semibold cursor-not-allowed">
                        Out of Stock
                    </button>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Related Products -->
    <?php if($relatedProducts->count() > 0): ?>
        <div class="mt-12">
            <h2 class="font-display text-3xl font-bold text-gray-900 mb-8">Related Products</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedProduct): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-xl transition">
                        <a href="<?php echo e(route('products.show', $relatedProduct->slug)); ?>">
                            <div class="relative h-64 bg-gray-200 overflow-hidden product-image-container" data-image-count="<?php echo e(1 + ($relatedProduct->images && is_array($relatedProduct->images) ? count($relatedProduct->images) : 0)); ?>">
                                <div class="product-images-wrapper">
                                    <img src="<?php echo e(productImageUrl($relatedProduct->image)); ?>" alt="<?php echo e($relatedProduct->name); ?>" class="product-image w-full h-full object-cover"
                                         onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                                <?php if($relatedProduct->images && is_array($relatedProduct->images) && count($relatedProduct->images) > 0): ?>
                                    <?php $__currentLoopData = $relatedProduct->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <img src="<?php echo e(productImageUrl($image)); ?>" alt="<?php echo e($relatedProduct->name); ?>" class="product-image w-full h-full object-cover"
                                                 onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="p-4">
                                <h3 class="font-semibold text-gray-900 mb-2"><?php echo e($relatedProduct->name); ?></h3>
                                <span class="text-primary font-bold text-lg"><?php echo e(currency($relatedProduct->price)); ?></span>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/products/show.blade.php ENDPATH**/ ?>