

<?php $__env->startSection('title', 'Checkout'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="font-display text-3xl font-bold text-gray-900 mb-8">Checkout</h1>

    <form action="<?php echo e(route('orders.store')); ?>" method="POST" class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <?php echo csrf_field(); ?>

        <!-- Checkout Information -->
        <div class="lg:col-span-2 space-y-6">
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="font-display text-2xl font-bold text-gray-900 mb-6">Checkout Information</h2>
                <div class="space-y-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Full Name *</label>
                        <input type="text" name="shipping_name" value="<?php echo e(old('shipping_name', auth()->check() ? auth()->user()->name : '')); ?>" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                        <?php $__errorArgs = ['shipping_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Email *</label>
                        <input type="email" name="shipping_email" value="<?php echo e(old('shipping_email', auth()->check() ? auth()->user()->email : '')); ?>" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                        <?php $__errorArgs = ['shipping_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Phone *</label>
                        <input type="tel" name="shipping_phone" value="<?php echo e(old('shipping_phone')); ?>" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
                        <?php $__errorArgs = ['shipping_phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Address *</label>
                        <textarea name="shipping_address" rows="3" required class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary"><?php echo e(old('shipping_address')); ?></textarea>
                        <?php $__errorArgs = ['shipping_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-sm mt-1"><?php echo e($message); ?></p>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>

            <!-- Payment Method -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="font-display text-2xl font-bold text-gray-900 mb-6">Payment Method</h2>
                <div class="space-y-4">
                    <div class="p-4 border border-gray-200 rounded-md hover:bg-gray-50 cursor-pointer">
                        <label class="flex items-center cursor-pointer w-full">
                            <input type="radio" name="payment_method" value="cash_on_delivery" checked class="h-5 w-5 text-primary border-gray-300 focus:ring-primary">
                            <span class="ml-3 text-lg font-semibold text-gray-900">Cash on Delivery</span>
                        </label>
                    </div>
                    <div class="p-4 border border-gray-200 rounded-md hover:bg-gray-50 cursor-pointer">
                        <label class="flex items-center cursor-pointer w-full">
                            <input type="radio" name="payment_method" value="paystack" class="h-5 w-5 text-primary border-gray-300 focus:ring-primary">
                            <span class="ml-3 text-lg font-semibold text-gray-900">Paystack (Credit/Debit Card)</span>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Notes -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <label class="block text-sm font-medium text-gray-700 mb-2">Order Notes (Optional)</label>
                <textarea name="notes" rows="4" class="w-full border border-gray-300 rounded-md px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary"><?php echo e(old('notes')); ?></textarea>
            </div>
        </div>

        <!-- Order Summary -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow-md p-6 sticky top-20">
                <h2 class="font-display text-2xl font-bold text-gray-900 mb-6">Order Summary</h2>
                <div class="space-y-4 mb-6">
                    <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($item->product): ?>
                        <div class="flex gap-4 pb-4 border-b border-gray-200">
                            <div class="w-16 h-16 bg-gray-200 rounded-lg overflow-hidden flex-shrink-0">
                                <img src="<?php echo e(productImageUrl($item->product->image ?? '')); ?>" alt="<?php echo e($item->product->name); ?>" class="w-full h-full object-cover"
                                     onerror="this.src='<?php echo e(asset('images/placeholder.jpg')); ?>'; this.onerror=null;">
                            </div>
                            <div class="flex-1">
                                <h3 class="font-semibold text-sm text-gray-900"><?php echo e($item->product->name); ?></h3>
                                <p class="text-gray-600 text-xs">Qty: <?php echo e($item->quantity); ?></p>
                                <p class="text-primary font-semibold text-sm"><?php echo e(currency($item->subtotal)); ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="space-y-2 pt-4">
                        <div class="flex justify-between text-gray-700">
                            <span>Subtotal</span>
                            <span><?php echo e(currency($subtotal)); ?></span>
                        </div>
                        <div class="border-t border-gray-300 pt-4">
                            <div class="flex justify-between text-gray-900 font-bold text-lg">
                                <span>Total</span>
                                <span><?php echo e(currency($total)); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
                <button type="submit" id="place-order-btn" class="w-full bg-primary text-white px-6 py-3 rounded-md text-center font-semibold hover:bg-primary-dark transition disabled:opacity-50 disabled:cursor-not-allowed">
                    <span id="btn-text">Place Order</span>
                    <span id="btn-loading" class="hidden">Processing...</span>
                </button>
            </div>
        </div>
    </form>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form[action="<?php echo e(route('orders.store')); ?>"]');
    const submitBtn = document.getElementById('place-order-btn');
    const btnText = document.getElementById('btn-text');
    const btnLoading = document.getElementById('btn-loading');
    let isSubmitting = false;

    if (form && submitBtn) {
        form.addEventListener('submit', function(e) {
            if (isSubmitting) {
                e.preventDefault();
                return false;
            }

            isSubmitting = true;
            submitBtn.disabled = true;
            btnText.classList.add('hidden');
            btnLoading.classList.remove('hidden');
        });
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/orders/checkout.blade.php ENDPATH**/ ?>