<?php $__env->startSection('title', 'Request Quotes'); ?>

<?php $__env->startSection('store-content'); ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-6">Request Quotes</h1>

        <?php if(session('success')): ?>
            <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
                <span class="block sm:inline"><?php echo e(session('success')); ?></span>
            </div>
        <?php endif; ?>

        <div class="bg-white shadow rounded-lg">
            <div class="px-4 py-5 sm:p-6">
                <?php if($quotes->isEmpty()): ?>
                    <div class="text-center py-12">
                        <p class="text-gray-500 text-lg">You have not received any quotes yet.</p>
                    </div>
                <?php else: ?>
                    <div class="divide-y divide-gray-200">
                        <?php $__currentLoopData = $quotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="py-6">
                                <div class="flex items-center justify-between">
                                    <div class="text-sm font-medium text-gray-900">
                                        <span class="font-bold">From:</span> <?php echo e($quote->user->name); ?>

                                    </div>
                                    <div class="text-sm text-gray-500">
                                        <?php echo e($quote->created_at->format('M d, Y')); ?>

                                    </div>
                                </div>
                                <?php if($quote->product): ?>
                                    <div class="mt-2 text-sm text-gray-600">
                                        <span class="font-bold">Product:</span> <?php echo e($quote->product->name); ?>

                                    </div>
                                <?php endif; ?>
                                <div class="mt-4">
                                    <p class="text-gray-800"><?php echo e($quote->message); ?></p>
                                </div>

                                <?php if($quote->reply): ?>
                                    <div class="mt-4 bg-gray-50 p-4 rounded-lg">
                                        <h4 class="font-semibold text-gray-800">Your Reply:</h4>
                                        <p class="text-gray-700"><?php echo e($quote->reply); ?></p>
                                    </div>
                                <?php else: ?>
                                    <form action="<?php echo e(route('store.request-quotes.reply', $quote)); ?>" method="POST" class="mt-4">
                                        <?php echo csrf_field(); ?>
                                        <div class="w-full">
                                            <label for="reply-<?php echo e($quote->id); ?>" class="sr-only">Your Reply</label>
                                            <textarea name="reply" id="reply-<?php echo e($quote->id); ?>" rows="3" class="shadow-sm focus:ring-indigo-500 focus:border-indigo-500 block w-full sm:text-sm border-gray-300 rounded-md" placeholder="Write your reply..."></textarea>
                                        </div>
                                        <div class="mt-3 text-right">
                                            <button type="submit" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
                                                Send Reply
                                            </button>
                                        </div>
                                    </form>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <div class="mt-6">
                        <?php echo e($quotes->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('store.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/store/quotes/index.blade.php ENDPATH**/ ?>