<?php $__env->startSection('title', 'Reviews'); ?>

<?php $__env->startSection('store-content'); ?>
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-6">Reviews</h1>

        <?php if($reviews->isEmpty()): ?>
            <div class="bg-white shadow rounded-lg p-8 text-center">
                <p class="text-gray-500 text-lg">You have not received any reviews yet.</p>
            </div>
        <?php else: ?>
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <ul class="divide-y divide-gray-200">
                    <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="p-6">
                            <div class="flex items-start">
                                <div class="flex-shrink-0">
                                    <img class="h-10 w-10 rounded-full" src="<?php echo e($review->user->profile_photo_url); ?>" alt="<?php echo e($review->user->name); ?>">
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($review->user->name); ?></div>
                                    <div class="flex items-center mt-1">
                                        <?php for($i = 0; $i < 5; $i++): ?>
                                            <svg class="h-5 w-5 <?php echo e($i < $review->rating ? 'text-yellow-400' : 'text-gray-300'); ?>" fill="currentColor" viewBox="0 0 20 20">
                                                <path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.817 5.955 6.572.955-4.756 4.635 1.123 6.545z" />
                                            </svg>
                                        <?php endfor; ?>
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500"><?php echo e($review->comment); ?></p>
                                </div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <div class="mt-6">
                <?php echo e($reviews->links()); ?>

            </div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('store.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/store/reviews/index.blade.php ENDPATH**/ ?>