

<?php $__env->startSection('title', 'Manage Popups - Admin'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8 flex items-center justify-between">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Popup Management</h1>
            <p class="text-gray-600 mt-2">Create and manage popups that appear on your website</p>
        </div>
        <a href="<?php echo e(route('admin.popups.create')); ?>" class="bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark transition">
            Create New Popup
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert">
            <p><?php echo e(session('success')); ?></p>
        </div>
    <?php endif; ?>

    <?php if($popups->count() > 0): ?>
        <div class="bg-white shadow overflow-hidden sm:rounded-md">
            <ul class="divide-y divide-gray-200">
                <?php $__currentLoopData = $popups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $popup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <div class="px-4 py-4 sm:px-6">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center space-x-4 flex-1">
                                    <?php if($popup->image): ?>
                                        <div class="flex-shrink-0">
                                            <img src="<?php echo e(productImageUrl($popup->image)); ?>" alt="<?php echo e($popup->title); ?>" 
                                                 class="h-20 w-20 object-cover rounded"
                                                 onerror="this.src='<?php echo e(url('images/placeholder.jpg')); ?>'; this.onerror=null;">
                                        </div>
                                    <?php endif; ?>
                                    <div class="flex-1 min-w-0">
                                        <div class="flex items-center space-x-2">
                                            <p class="text-lg font-semibold text-gray-900"><?php echo e($popup->title); ?></p>
                                            <?php if($popup->is_active): ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                    Active
                                                </span>
                                            <?php else: ?>
                                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                    Inactive
                                                </span>
                                            <?php endif; ?>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                                <?php echo e(ucfirst($popup->type)); ?>

                                            </span>
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                                                <?php echo e(ucfirst(str_replace('-', ' ', $popup->position))); ?>

                                            </span>
                                        </div>
                                        <p class="text-sm text-gray-500 mt-1">
                                            Audience: <?php echo e(ucfirst(str_replace('_', ' ', $popup->target_audience))); ?>

                                            <?php if($popup->target_roles && count($popup->target_roles) > 0): ?>
                                                (<?php echo e(implode(', ', $popup->target_roles)); ?>)
                                            <?php endif; ?>
                                        </p>
                                        <p class="text-sm text-gray-500">
                                            Priority: <?php echo e($popup->priority); ?> | 
                                            Delay: <?php echo e($popup->delay_seconds); ?>s
                                            <?php if($popup->start_date || $popup->end_date): ?>
                                                | 
                                                <?php if($popup->start_date): ?>
                                                    Starts: <?php echo e($popup->start_date->format('M d, Y')); ?>

                                                <?php endif; ?>
                                                <?php if($popup->end_date): ?>
                                                    Ends: <?php echo e($popup->end_date->format('M d, Y')); ?>

                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </p>
                                    </div>
                                </div>
                                <div class="flex items-center space-x-2">
                                    <a href="<?php echo e(route('admin.popups.preview', $popup)); ?>" 
                                       target="_blank"
                                       class="text-blue-600 hover:text-blue-800" title="Preview">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                        </svg>
                                    </a>
                                    <a href="<?php echo e(route('admin.popups.edit', $popup)); ?>" 
                                       class="text-primary hover:text-primary-dark" title="Edit">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                        </svg>
                                    </a>
                                    <form action="<?php echo e(route('admin.popups.destroy', $popup)); ?>" method="POST" 
                                          onsubmit="return confirm('Are you sure you want to delete this popup?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="text-red-600 hover:text-red-800">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php else: ?>
        <div class="bg-white shadow rounded-lg p-12 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 10l4.553-2.276A1 1 0 0121 8.618v6.764a1 1 0 01-1.447.894L15 14M5 18h8a2 2 0 002-2V8a2 2 0 00-2-2H5a2 2 0 00-2 2v8a2 2 0 002 2z"/>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No popups</h3>
            <p class="mt-1 text-sm text-gray-500">Get started by creating a new popup.</p>
            <div class="mt-6">
                <a href="<?php echo e(route('admin.popups.create')); ?>" class="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-primary hover:bg-primary-dark">
                    Create Popup
                </a>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\TrendzTrade\resources\views/admin/popups/index.blade.php ENDPATH**/ ?>