@extends('store.layout')

@section('title', 'Withdraw')

@section('store-content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Withdrawals</h1>
            <p class="text-gray-600 mt-1">Manage your earnings and withdrawal requests</p>
        </div>
    </div>

    <!-- Balance & Withdrawal Card -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- Current Balance -->
        <div class="bg-gradient-to-br from-green-500 to-green-600 rounded-xl shadow-xl p-8 text-white">
            <div class="flex items-center justify-between mb-6">
                <h2 class="text-xl font-semibold">Available Balance</h2>
                <svg class="w-8 h-8 text-white/80" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                </svg>
            </div>
            <p class="text-4xl font-bold mb-2">{{ currency($store->pending_earnings ?? 0) }}</p>
            <p class="text-green-100 text-sm">Ready for withdrawal</p>
            <div class="mt-6 pt-6 border-t border-white/20">
                <div class="flex items-center justify-between text-sm">
                    <span class="text-green-100">Total Earnings:</span>
                    <span class="font-semibold">{{ currency($store->total_earnings ?? 0) }}</span>
                </div>
            </div>
        </div>

        <!-- Withdrawal Form -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-100 p-8">
            <h2 class="text-xl font-bold text-gray-900 mb-6">Request Withdrawal</h2>
            
            @if(session('success'))
                <div class="mb-4 p-4 bg-green-50 border-l-4 border-green-400 rounded-lg">
                    <p class="text-sm text-green-700">{{ session('success') }}</p>
                </div>
            @endif

            @if($errors->any())
                <div class="mb-4 p-4 bg-red-50 border-l-4 border-red-400 rounded-lg">
                    <ul class="list-disc list-inside text-sm text-red-700">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('store.withdraw.request') }}" method="POST" class="space-y-6">
                @csrf
                
                <div>
                    <label for="amount" class="block text-sm font-semibold text-gray-700 mb-2">
                        Withdrawal Amount
                    </label>
                    <div class="relative">
                        <input type="number" 
                               name="amount" 
                               id="amount" 
                               class="w-full px-4 py-3 border-2 border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition text-lg font-semibold"
                               placeholder="0.00"
                               required 
                               min="1" 
                               max="{{ $store->pending_earnings ?? 0 }}" 
                               step="0.01">
                        <div class="absolute inset-y-0 right-0 pr-4 flex items-center">
                            <span class="text-gray-500 font-medium">{{ $currentCurrency ?? 'GHS' }}</span>
                        </div>
                    </div>
                    <p class="mt-2 text-sm text-gray-500">
                        Maximum: <span class="font-semibold text-gray-700">{{ currency($store->pending_earnings ?? 0) }}</span>
                    </p>
                </div>

                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4">
                    <div class="flex items-start gap-3">
                        <svg class="w-5 h-5 text-blue-600 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                        </svg>
                        <div class="text-sm text-blue-700">
                            <p class="font-semibold mb-1">Withdrawal Information</p>
                            <p>Withdrawal requests are processed within 3-5 business days. You will be notified once your request is approved and processed.</p>
                        </div>
                    </div>
                </div>

                <button type="submit" 
                        class="w-full bg-primary hover:bg-primary-dark text-white font-bold py-3 px-6 rounded-xl shadow-lg hover:shadow-xl transition-all">
                    Request Withdrawal
                </button>
            </form>
        </div>
    </div>

    <!-- Withdrawal History -->
    <div class="bg-white rounded-xl shadow-lg border border-gray-100 overflow-hidden">
        <div class="p-6 border-b border-gray-200">
            <h2 class="text-xl font-bold text-gray-900">Withdrawal History</h2>
            <p class="text-sm text-gray-500 mt-1">Track all your withdrawal requests</p>
        </div>
        
        @if($withdrawals->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Date</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Amount</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Status</th>
                            <th scope="col" class="px-6 py-4 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">Reference</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($withdrawals as $withdrawal)
                            <tr class="hover:bg-gray-50 transition">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div>
                                        <p class="text-sm font-medium text-gray-900">{{ $withdrawal->created_at->format('M d, Y') }}</p>
                                        <p class="text-xs text-gray-500">{{ $withdrawal->created_at->format('h:i A') }}</p>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <p class="text-sm font-bold text-gray-900">{{ currency($withdrawal->amount) }}</p>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @php
                                        $statusColors = [
                                            'pending' => 'bg-yellow-100 text-yellow-800',
                                            'processing' => 'bg-blue-100 text-blue-800',
                                            'completed' => 'bg-green-100 text-green-800',
                                            'rejected' => 'bg-red-100 text-red-800',
                                        ];
                                        $statusColor = $statusColors[$withdrawal->status] ?? 'bg-gray-100 text-gray-800';
                                    @endphp
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium {{ $statusColor }}">
                                        <span class="w-2 h-2 rounded-full mr-2 
                                            {{ $withdrawal->status === 'completed' ? 'bg-green-500' : 
                                               ($withdrawal->status === 'pending' ? 'bg-yellow-500' : 
                                               ($withdrawal->status === 'processing' ? 'bg-blue-500' : 'bg-gray-500')) }}">
                                        </span>
                                        {{ ucfirst($withdrawal->status) }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <p class="text-sm text-gray-500">#{{ $withdrawal->id }}</p>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <div class="px-6 py-4 border-t border-gray-200">
                {{ $withdrawals->links() }}
            </div>
        @else
            <div class="p-12 text-center">
                <svg class="w-16 h-16 text-gray-300 mx-auto mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"/>
                </svg>
                <p class="text-gray-500">No withdrawal history yet</p>
            </div>
        @endif
    </div>
</div>
@endsection
