@extends('store.layout')

@section('title', 'Reviews')

@section('store-content')
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-6">Reviews</h1>

        @if ($reviews->isEmpty())
            <div class="bg-white shadow rounded-lg p-8 text-center">
                <p class="text-gray-500 text-lg">You have not received any reviews yet.</p>
            </div>
        @else
            <div class="bg-white shadow rounded-lg overflow-hidden">
                <ul class="divide-y divide-gray-200">
                    @foreach ($reviews as $review)
                        <li class="p-6">
                            <div class="flex items-start">
                                <div class="flex-shrink-0">
                                    <img class="h-10 w-10 rounded-full" src="{{ $review->user->profile_photo_url }}" alt="{{ $review->user->name }}">
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900">{{ $review->user->name }}</div>
                                    <div class="flex items-center mt-1">
                                        @for ($i = 0; $i < 5; $i++)
                                            <svg class="h-5 w-5 {{ $i < $review->rating ? 'text-yellow-400' : 'text-gray-300' }}" fill="currentColor" viewBox="0 0 20 20">
                                                <path d="M10 15l-5.878 3.09 1.123-6.545L.489 6.91l6.572-.955L10 0l2.817 5.955 6.572.955-4.756 4.635 1.123 6.545z" />
                                            </svg>
                                        @endfor
                                    </div>
                                    <p class="mt-2 text-sm text-gray-500">{{ $review->comment }}</p>
                                </div>
                            </div>
                        </li>
                    @endforeach
                </ul>
            </div>
            <div class="mt-6">
                {{ $reviews->links() }}
            </div>
        @endif
    </div>
@endsection
