@extends('store.layout')

@section('title', 'Store Dashboard')

@section('store-content')
<style>
    /* Stats Grid */
    .stats-grid {
        display: grid;
        grid-template-columns: repeat(3, 1fr);
        gap: 24px;
    }

    .stats-card {
        background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
        border-radius: 20px;
        padding: 1.25rem 1.5rem;
        color: white;
        position: relative;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(124, 58, 237, 0.2);
    }

    .stats-card:nth-child(1) {
        background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%);
        box-shadow: 0 10px 30px rgba(124, 58, 237, 0.2);
    }

    .stats-card:nth-child(2) {
        background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%);
        box-shadow: 0 10px 30px rgba(59, 130, 246, 0.2);
    }

    .stats-card:nth-child(3) {
        background: linear-gradient(135deg, #6366F1 0%, #4F46E5 100%);
        box-shadow: 0 10px 30px rgba(99, 102, 241, 0.2);
    }

    .stats-card::before {
        content: '';
        position: absolute;
        width: 80px;
        height: 80px;
        background: rgba(255,255,255,0.1);
        border-radius: 50%;
        top: -20px;
        right: -20px;
    }

    .stats-card-title {
        font-size: 0.7rem;
        font-weight: 700;
        text-transform: uppercase;
        margin-bottom: 0.5rem;
        opacity: 0.8;
        letter-spacing: 0.5px;
        position: relative;
        z-index: 1;
    }

    .stats-card-value {
        font-size: 1.75rem;
        font-weight: 800;
        position: relative;
        z-index: 1;
    }

    .analytics-grid {
        display: grid;
        grid-template-columns: 2fr 1fr;
        gap: 24px;
    }

    .section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 1.5rem;
    }

    .section-title {
        font-size: 1.1rem;
        font-weight: 800;
        color: var(--text-main);
    }

    .table-card {
        background: #ffffff;
        border-radius: 24px;
        border: 1px solid var(--border-color);
        overflow-x: auto;
        box-shadow: 0 4px 20px rgba(0,0,0,0.02);
    }

    table {
        width: 100%;
        border-collapse: collapse;
    }

    th {
        text-align: left;
        padding: 1.25rem 1.5rem;
        font-size: 0.75rem;
        font-weight: 800;
        color: var(--text-muted);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        border-bottom: 1px solid var(--border-color);
        background: #fcfdfe;
    }

    td {
        padding: 1.25rem 1.5rem;
        font-size: 0.9rem;
        color: var(--text-main);
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
    }

    tr:last-child td {
        border-bottom: none;
    }

    tr:hover {
        background: #f8fafc;
    }

    .status-badge {
        display: inline-flex;
        padding: 6px 12px;
        border-radius: 8px;
        font-size: 0.75rem;
        font-weight: 800;
    }

    .status-success { background: #dcfce7; color: #166534; }
    .status-pending { background: #fef9c3; color: #854d0e; }
    .status-processing { background: #dbeafe; color: #1e40af; }

    .inventory-card {
        background: #f8fafc;
        border-radius: 20px;
        padding: 1.5rem;
        display: flex;
        align-items: center;
        justify-content: space-between;
        position: relative;
        border: 1px solid var(--border-color);
    }

    .system-status-card {
        background: #ffffff;
        border-radius: 20px;
        padding: 1.25rem;
        text-align: center;
        border: 1px solid var(--border-color);
        box-shadow: 0 10px 40px rgba(0,0,0,0.03);
    }

    @media (max-width: 992px) {
        .analytics-grid {
            grid-template-columns: 1fr;
            gap: 16px;
        }
    }

    @media (max-width: 768px) {
        .stats-grid {
            gap: 10px;
        }
        .stats-card {
            padding: 1.25rem 0.75rem !important;
            min-height: 100px;
            display: flex;
            flex-direction: column;
            justify-content: center;
        }
        .stats-card-title {
            font-size: 0.65rem !important;
            margin-bottom: 0.25rem !important;
        }
        .stats-card-value {
            font-size: 1.2rem !important;
        }
        .system-status-card {
            display: none !important;
        }
    }
</style>

<!-- Dashboard Header -->
<div style="display: flex; justify-content: space-between; align-items: center;">
    <div style="display: flex; align-items: center; gap: 1rem;">
        <h1 style="font-size: 1.5rem; font-weight: 800; color: var(--text-main);">Business Dashboard</h1>
        @if($store->status === 'pending')
            <span style="background: #fef9c3; color: #854d0e; padding: 4px 12px; border-radius: 8px; font-size: 0.75rem; font-weight: 800;">
                <i class="fas fa-clock"></i> Pending Approval
            </span>
        @elseif($store->status === 'suspended')
            <span style="background: #fee2e2; color: #991b1b; padding: 4px 12px; border-radius: 8px; font-size: 0.75rem; font-weight: 800;">
                <i class="fas fa-ban"></i> Suspended
            </span>
        @elseif($store->status === 'approved')
            <span style="background: #dcfce7; color: #166534; padding: 4px 12px; border-radius: 8px; font-size: 0.75rem; font-weight: 800;">
                <i class="fas fa-check-circle"></i> Active
            </span>
        @endif
    </div>
    <div style="display: flex; gap: 0.75rem;">
        @if($store->status === 'approved')
            <a href="{{ route('store.show', $store->slug) }}" target="_blank" style="width: 44px; height: 44px; border-radius: 14px; border: none; background: #f8fafc; color: var(--text-main); cursor: pointer; transition: all 0.2s; display: grid; place-items: center; text-decoration: none;" title="View Store">
                <i class="fas fa-external-link-alt"></i>
            </a>
        @endif
    </div>
</div>

<!-- Top Stats Row -->
<div class="stats-grid">
    <!-- Total Earnings -->
    <div class="stats-card" style="background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%); box-shadow: 0 10px 30px rgba(59, 130, 246, 0.2);">
        <div class="stats-card-title">Income</div>
        <div class="stats-card-value">{{ currency($stats['total_earnings']) }}</div>
    </div>

    <!-- Total Orders -->
    <div class="stats-card" style="background: linear-gradient(135deg, #8B5CF6 0%, #7C3AED 100%); box-shadow: 0 10px 30px rgba(124, 58, 237, 0.2);">
        <div class="stats-card-title">Orders</div>
        <div class="stats-card-value">{{ number_format($stats['total_orders']) }}</div>
    </div>

    <!-- Total Products -->
    <div class="stats-card" style="background: linear-gradient(135deg, #6366F1 0%, #4F46E5 100%); box-shadow: 0 10px 30px rgba(99, 102, 241, 0.2);">
        <div class="stats-card-title">Products</div>
        <div class="stats-card-value">{{ number_format($stats['total_products']) }}</div>
    </div>
</div>

<!-- Middle Grid: Analytics & Status -->
<div class="analytics-grid">
    <div class="inventory-card">
        <div>
            <h3 style="font-size: 1rem; font-weight: 800; margin-bottom: 0.25rem;">Store Overview</h3>
            <p style="color: var(--text-muted); font-size: 0.8rem; max-width: 250px; line-height: 1.5;">Active products relative to total catalog.</p>
        </div>
        <div style="width: 80px; height: 80px; position: relative; display: grid; place-items: center;">
            @php
                $activePercent = $stats['total_products'] > 0 ? round(($stats['active_products'] / $stats['total_products']) * 100) : 0;
            @endphp
            <svg viewBox="0 0 36 36" style="width: 100%; height: 100%; transform: rotate(-90deg);">
                <path d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" fill="none" stroke="#e2e8f0" stroke-width="2.5" />
                <path d="M18 2.0845 a 15.9155 15.9155 0 0 1 0 31.831 a 15.9155 15.9155 0 0 1 0 -31.831" fill="none" stroke="#4f46e5" stroke-width="2.5" stroke-dasharray="{{ $activePercent }}, 100" stroke-linecap="round" />
            </svg>
            <div style="position: absolute; text-align: center;">
                <div style="font-weight: 800; font-size: 1rem; color: var(--text-main);">{{ $activePercent }}%</div>
            </div>
        </div>
    </div>

    <div class="system-status-card">
        <div style="color: #6366f1; font-size: 0.65rem; font-weight: 800; text-transform: uppercase; margin-bottom: 1rem; letter-spacing: 1px;">Store Status</div>
        <div style="width: 50px; height: 50px; background: {{ $store->status === 'approved' ? '#dcfce7' : ($store->status === 'pending' ? '#fef9c3' : '#fee2e2') }}; border-radius: 14px; margin: 0 auto 0.75rem; display: grid; place-items: center; color: {{ $store->status === 'approved' ? '#16a34a' : ($store->status === 'pending' ? '#ca8a04' : '#dc2626') }}; font-size: 1.25rem; transform: rotate(-5deg);">
            <i class="fas {{ $store->status === 'approved' ? 'fa-check-circle' : ($store->status === 'pending' ? 'fa-clock' : 'fa-ban') }}"></i>
        </div>
        <div style="font-weight: 800; font-size: 1.1rem; margin-bottom: 0.25rem;">{{ ucfirst($store->status) }}</div>
        <p style="font-size: 0.75rem; color: var(--text-muted);">{{ $store->status === 'approved' ? 'Running normally' : ($store->status === 'pending' ? 'Awaiting approval' : 'Account suspended') }}</p>
    </div>
</div>

<!-- Recent Orders Table -->
<div>
    <div class="section-header">
        <h3 class="section-title">Recent Orders</h3>
        <a href="{{ route('store.orders.index') }}" style="font-size: 0.8rem; font-weight: 700; text-decoration: none; color: #64748b; text-transform: uppercase; letter-spacing: 0.5px;">See All</a>
    </div>
    <div class="table-card">
        <table>
            @if($recentOrders->count() > 0)
                <thead>
                    <tr>
                        <th>Order #</th>
                        <th>Customer</th>
                        <th>Date</th>
                        <th style="text-align: right;">Amount</th>
                        <th style="text-align: right;">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($recentOrders as $order)
                        <tr>
                            <td style="color: var(--text-muted); font-size: 0.9rem; font-weight: 600;">#{{ $order->order_number ?? $order->id }}</td>
                            <td style="font-weight: 700; font-size: 0.95rem;">{{ $order->user ? $order->user->name : ($order->shipping_name ?? 'Guest') }}</td>
                            <td style="color: var(--text-muted);">{{ $order->created_at->format('M d, Y') }}</td>
                            <td style="font-weight: 800; text-align: right;">{{ currency($order->total) }}</td>
                            <td style="text-align: right;">
                                <span class="status-badge status-{{ $order->status === 'completed' ? 'success' : ($order->status === 'pending' ? 'pending' : 'processing') }}">
                                    {{ ucfirst($order->status) }}
                                </span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            @else
                <tbody>
                    <tr>
                        <td colspan="5" style="padding: 2rem; text-align: center; color: var(--text-muted);">No orders found.</td>
                    </tr>
                </tbody>
            @endif
        </table>
    </div>
</div>
@endsection

@push('summary-content')
<h2 style="font-size: 1.25rem; font-weight: 800; margin-bottom: 2.5rem;">Summary</h2>
<div style="color: var(--text-muted); font-size: 0.9rem; font-weight: 600; margin-bottom: 0.75rem;">Today's Revenue</div>
<div style="font-size: 2.5rem; font-weight: 800; color: var(--text-main); margin-bottom: 0.75rem;">{{ currency($stats['today_earnings']) }}</div>
<div style="font-size: 0.9rem; background: #f0fdf4; display: inline-block; padding: 6px 12px; border-radius: 8px;">
    <span style="color: #166534; font-weight: 700;">TODAY</span>
    <span style="color: #166534; margin-left: 4px; font-weight: 500;">stats</span>
</div>

<div style="margin-top: 2rem;">
    <div style="display: flex; justify-content: space-between; margin-bottom: 1.5rem;">
        <h3 style="font-size: 1.1rem; font-weight: 800;">Recent Activity</h3>
        <a href="{{ route('store.orders.index') }}" style="font-size: 0.75rem; font-weight: 700; text-decoration: none; color: #94a3b8; text-transform: uppercase;">SEE ALL</a>
    </div>
    <div style="display: flex; flex-direction: column; gap: 2rem;">
        @forelse($recentOrders->take(3) as $act)
            <div style="display: flex; gap: 1rem; align-items: flex-start;">
                <div style="width: 48px; height: 48px; background: {{ $act->status === 'completed' ? '#e0e7ff' : '#fef2f2' }}; border-radius: 14px; color: {{ $act->status === 'completed' ? '#4f46e5' : '#ef4444' }}; display: grid; place-items: center; flex-shrink: 0;">
                    <i class="fas {{ $act->status === 'completed' ? 'fa-wallet' : 'fa-exclamation-circle' }}"></i>
                </div>
                <div>
                    <div style="font-size: 0.95rem; font-weight: 700;">{{ $act->status === 'completed' ? 'Order Completed' : 'Order ' . ucfirst($act->status) }}</div>
                    <div style="font-size: 0.8rem; color: var(--text-muted);">{{ $act->created_at->format('h:i a') }} - {{ currency($act->total) }}</div>
                </div>
            </div>
        @empty
            <div style="color: var(--text-muted); font-size: 0.85rem;">No recent activity.</div>
        @endforelse
    </div>
</div>

<div style="margin-top: 2rem;">
    <h3 style="font-size: 1.1rem; font-weight: 800; margin-bottom: 1rem;">Quick Stats</h3>
    <div style="display: flex; gap: 1rem; flex-wrap: wrap;">
        <div style="flex: 1; min-width: 100px; background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%); padding: 1.5rem; border-radius: 20px; text-align: center; color: white; box-shadow: 0 10px 20px rgba(0,0,0,0.05);">
            <div style="width: 40px; height: 40px; background: rgba(255,255,255,0.2); border-radius: 50%; color: white; display: grid; place-items: center; margin: 0 auto 1rem;"><i class="fas fa-users"></i></div>
            <div style="font-size: 0.9rem; font-weight: 800; color: #ffffff;">Customers</div>
            <div style="font-size: 0.75rem; opacity: 0.9; color: #ffffff; font-weight: 600;">{{ number_format($stats['total_customers']) }}</div>
        </div>
        <div style="flex: 1; min-width: 100px; background: linear-gradient(135deg, #10B981 0%, #059669 100%); padding: 1.5rem; border-radius: 20px; text-align: center; color: white; box-shadow: 0 10px 20px rgba(0,0,0,0.05);">
            <div style="width: 40px; height: 40px; background: rgba(255,255,255,0.2); border-radius: 50%; color: white; display: grid; place-items: center; margin: 0 auto 1rem;"><i class="fas fa-check-circle"></i></div>
            <div style="font-size: 0.9rem; font-weight: 800; color: #ffffff;">Active</div>
            <div style="font-size: 0.75rem; opacity: 0.9; color: #ffffff; font-weight: 600;">{{ $stats['active_products'] }} products</div>
        </div>
    </div>
</div>
@endpush
