@extends('store.layout')

@section('title', 'Coupons')

@section('store-content')
<div class="space-y-6">
    <!-- Header -->
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h1 class="text-3xl font-bold text-gray-900">Coupons</h1>
            <p class="text-gray-600 mt-1">Create and manage discount coupons</p>
        </div>
        <a href="{{ route('store.coupons.create') }}" 
           class="inline-flex items-center gap-2 bg-primary hover:bg-primary-dark text-white font-semibold px-6 py-3 rounded-xl shadow-lg hover:shadow-xl transition-all">
            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Create Coupon
        </a>
    </div>

    @if ($coupons->isEmpty())
        <!-- Empty State -->
        <div class="bg-white rounded-xl shadow-lg border border-gray-100 p-12 text-center">
            <div class="max-w-md mx-auto">
                <svg class="w-24 h-24 text-gray-300 mx-auto mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                </svg>
                <h3 class="text-xl font-bold text-gray-900 mb-2">No coupons yet</h3>
                <p class="text-gray-600 mb-6">Create your first discount coupon to attract more customers.</p>
                <a href="{{ route('store.coupons.create') }}" 
                   class="inline-flex items-center gap-2 bg-primary hover:bg-primary-dark text-white font-semibold px-6 py-3 rounded-xl shadow-lg hover:shadow-xl transition-all">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
                    </svg>
                    Create Your First Coupon
                </a>
            </div>
        </div>
    @else
        <!-- Coupons Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach ($coupons as $coupon)
                <div class="bg-gradient-to-br from-white to-gray-50 rounded-xl shadow-lg border border-gray-200 overflow-hidden hover:shadow-xl transition-all">
                    <!-- Coupon Header -->
                    <div class="bg-gradient-to-r from-primary to-primary-dark p-6 text-white">
                        <div class="flex items-start justify-between">
                            <div>
                                <p class="text-2xl font-bold mb-1">{{ $coupon->code }}</p>
                                <p class="text-white/80 text-sm">{{ $coupon->description ?? 'Discount Coupon' }}</p>
                            </div>
                            <div class="text-right">
                                @if ($coupon->type == 'percentage')
                                    <p class="text-3xl font-bold">{{ $coupon->discount }}%</p>
                                    <p class="text-sm text-white/80">OFF</p>
                                @else
                                    <p class="text-2xl font-bold">{{ currency($coupon->discount) }}</p>
                                    <p class="text-sm text-white/80">OFF</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Coupon Details -->
                    <div class="p-6 space-y-4">
                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-600">Status:</span>
                            @if ($coupon->expires_at && $coupon->expires_at->isPast())
                                <span class="px-3 py-1 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                    Expired
                                </span>
                            @else
                                <span class="px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    Active
                                </span>
                            @endif
                        </div>

                        <div class="flex items-center justify-between text-sm">
                            <span class="text-gray-600">Type:</span>
                            <span class="font-medium text-gray-900 capitalize">{{ $coupon->type }}</span>
                        </div>

                        @if ($coupon->minimum_amount)
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-gray-600">Min. Purchase:</span>
                                <span class="font-medium text-gray-900">{{ currency($coupon->minimum_amount) }}</span>
                            </div>
                        @endif

                        @if ($coupon->usage_limit)
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-gray-600">Usage Limit:</span>
                                <span class="font-medium text-gray-900">{{ number_format($coupon->usage_limit) }} uses</span>
                            </div>
                        @endif

                        @if ($coupon->expires_at)
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-gray-600">Expires:</span>
                                <span class="font-medium text-gray-900">{{ $coupon->expires_at->format('M d, Y') }}</span>
                            </div>
                        @else
                            <div class="flex items-center justify-between text-sm">
                                <span class="text-gray-600">Expires:</span>
                                <span class="font-medium text-gray-900">Never</span>
                            </div>
                        @endif

                        <!-- Actions -->
                        <div class="pt-4 border-t border-gray-200 flex items-center gap-2">
                            <a href="{{ route('store.coupons.edit', $coupon) }}" 
                               class="flex-1 text-center bg-gray-100 hover:bg-gray-200 text-gray-700 font-medium py-2 px-4 rounded-lg transition">
                                Edit
                            </a>
                            <form action="{{ route('store.coupons.destroy', $coupon) }}" method="POST" class="flex-1" onsubmit="return confirm('Are you sure you want to delete this coupon?');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="w-full bg-red-100 hover:bg-red-200 text-red-700 font-medium py-2 px-4 rounded-lg transition">
                                    Delete
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <!-- Pagination -->
        @if($coupons->hasPages())
            <div class="flex justify-center">
                {{ $coupons->links() }}
            </div>
        @endif
    @endif
</div>
@endsection
