@extends('store.layout')

@section('title', 'Announcements')

@section('store-content')
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <h1 class="text-3xl font-bold text-gray-900 mb-6">Announcements</h1>
        <div class="space-y-6">
            @forelse ($announcements as $announcement)
                <div class="bg-white shadow rounded-lg p-6">
                    <h2 class="text-xl font-bold text-gray-900">{{ $announcement->title }}</h2>
                    <p class="mt-2 text-gray-600">{{ $announcement->content }}</p>
                    <p class="mt-4 text-sm text-gray-500">{{ $announcement->created_at->format('M d, Y') }}</p>
                </div>
            @empty
                <div class="bg-white shadow rounded-lg p-8 text-center">
                    <p class="text-gray-500 text-lg">No announcements found.</p>
                </div>
            @endforelse
        </div>
        <div class="mt-6">
            {{ $announcements->links() }}
        </div>
    </div>
@endsection
