@extends('layouts.app')

@section('title', 'Size Guide')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section -->
    <section class="text-white py-16 md:py-24" style="background: linear-gradient(135deg, {{ $primaryColor ?? '#ff5349' }} 0%, {{ $primaryColor ?? '#ff5349' }}dd 100%);">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-black mb-6 text-white">Size Guide</h1>
                <p class="text-xl md:text-2xl text-white/90 leading-relaxed">
                    Find your perfect fit with our comprehensive sizing guide
                </p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section class="py-12 md:py-16">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Women's Size Guide -->
            <div class="bg-white rounded-xl shadow-lg p-8 md:p-12 mb-8">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">Women's Size Guide</h2>
                <div class="overflow-x-auto">
                    <table class="w-full border-collapse">
                        <thead>
                            <tr class="bg-gray-100">
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Size</th>
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Bust (inches)</th>
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Waist (inches)</th>
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Hips (inches)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">XS</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">32-33</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">24-25</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">34-35</td>
                            </tr>
                            <tr class="bg-gray-50">
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">S</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">34-35</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">26-27</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">36-37</td>
                            </tr>
                            <tr>
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">M</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">36-37</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">28-29</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">38-39</td>
                            </tr>
                            <tr class="bg-gray-50">
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">L</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">38-40</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">30-32</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">40-42</td>
                            </tr>
                            <tr>
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">XL</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">42-44</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">34-36</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">44-46</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Men's Size Guide -->
            <div class="bg-white rounded-xl shadow-lg p-8 md:p-12 mb-8">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">Men's Size Guide</h2>
                <div class="overflow-x-auto">
                    <table class="w-full border-collapse">
                        <thead>
                            <tr class="bg-gray-100">
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Size</th>
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Chest (inches)</th>
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Waist (inches)</th>
                                <th class="border border-gray-300 px-4 py-3 text-left font-semibold text-gray-900">Hips (inches)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">S</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">36-38</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">30-32</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">36-38</td>
                            </tr>
                            <tr class="bg-gray-50">
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">M</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">38-40</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">32-34</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">38-40</td>
                            </tr>
                            <tr>
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">L</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">40-42</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">34-36</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">40-42</td>
                            </tr>
                            <tr class="bg-gray-50">
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">XL</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">42-44</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">36-38</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">42-44</td>
                            </tr>
                            <tr>
                                <td class="border border-gray-300 px-4 py-3 font-medium text-gray-900">XXL</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">44-46</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">38-40</td>
                                <td class="border border-gray-300 px-4 py-3 text-gray-700">44-46</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- How to Measure -->
            <div class="bg-white rounded-xl shadow-lg p-8 md:p-12">
                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 mb-6">How to Measure</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-gray-50 rounded-lg p-6">
                        <h3 class="text-xl font-bold text-gray-900 mb-3">For Women</h3>
                        <ul class="space-y-3 text-gray-700">
                            <li class="flex items-start gap-2">
                                <span class="text-primary font-bold">•</span>
                                <span><strong>Bust:</strong> Measure around the fullest part of your chest</span>
                            </li>
                            <li class="flex items-start gap-2">
                                <span class="text-primary font-bold">•</span>
                                <span><strong>Waist:</strong> Measure around the narrowest part of your waist</span>
                            </li>
                            <li class="flex items-start gap-2">
                                <span class="text-primary font-bold">•</span>
                                <span><strong>Hips:</strong> Measure around the fullest part of your hips</span>
                            </li>
                        </ul>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-6">
                        <h3 class="text-xl font-bold text-gray-900 mb-3">For Men</h3>
                        <ul class="space-y-3 text-gray-700">
                            <li class="flex items-start gap-2">
                                <span class="text-primary font-bold">•</span>
                                <span><strong>Chest:</strong> Measure around the fullest part of your chest, under your arms</span>
                            </li>
                            <li class="flex items-start gap-2">
                                <span class="text-primary font-bold">•</span>
                                <span><strong>Waist:</strong> Measure around your natural waistline</span>
                            </li>
                            <li class="flex items-start gap-2">
                                <span class="text-primary font-bold">•</span>
                                <span><strong>Hips:</strong> Measure around the fullest part of your hips</span>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="mt-6 bg-primary/10 rounded-lg p-6">
                    <p class="text-gray-700">
                        <strong>Tip:</strong> When measuring, keep the tape measure snug but not tight. For the most accurate fit, 
                        measure yourself while wearing lightweight clothing or undergarments.
                    </p>
                </div>
            </div>

            <!-- Need Help -->
            <div class="mt-8 bg-white rounded-xl shadow-lg p-8 md:p-10 text-center">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">Still Unsure About Your Size?</h2>
                <p class="text-gray-600 mb-6">
                    Our customer service team can help you find the perfect fit!
                </p>
                <a href="{{ route('pages.contact') }}" class="inline-flex items-center gap-2 bg-primary text-white px-8 py-4 rounded-lg font-bold hover:bg-primary-dark transition shadow-lg hover:shadow-xl">
                    Contact Us
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
        </div>
    </section>
</div>
@endsection

