@extends('layouts.app')

@section('title', 'Returns & Exchanges')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section -->
    <section class="text-white py-16 md:py-24" style="background: linear-gradient(135deg, {{ $primaryColor ?? '#ff5349' }} 0%, {{ $primaryColor ?? '#ff5349' }}dd 100%);">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-black mb-6 text-white">Returns & Exchanges</h1>
                <p class="text-xl md:text-2xl text-white/90 leading-relaxed">
                    Easy returns and exchanges for your peace of mind
                </p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section class="py-12 md:py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white rounded-xl shadow-lg p-8 md:p-12 space-y-8">
                <div class="prose prose-lg max-w-none">
                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">Return Policy</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        We want you to be completely satisfied with your purchase. If you're not happy with your order, 
                        you can return it within 30 days of delivery for a full refund or exchange.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4 mt-8">Eligibility for Returns</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        To be eligible for a return, your item must be:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Unworn, unwashed, and in original condition</li>
                        <li>In original packaging with all tags attached</li>
                        <li>Returned within 30 days of delivery</li>
                        <li>Accompanied by proof of purchase</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4 mt-8">How to Return</h2>
                    <div class="space-y-4 mb-6">
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">1</div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Contact Us</h3>
                                <p class="text-gray-700">Email us at returns@example.com or contact our customer service team to initiate your return.</p>
                            </div>
                        </div>
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">2</div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Package Your Item</h3>
                                <p class="text-gray-700">Place the item in its original packaging with all tags attached. Include your order number.</p>
                            </div>
                        </div>
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">3</div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Ship It Back</h3>
                                <p class="text-gray-700">We'll provide you with a return shipping label. Ship the package to our return address.</p>
                            </div>
                        </div>
                        <div class="flex items-start gap-4">
                            <div class="flex-shrink-0 w-8 h-8 bg-primary text-white rounded-full flex items-center justify-center font-bold">4</div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2">Receive Refund</h3>
                                <p class="text-gray-700">Once we receive and inspect your return, we'll process your refund within 5-7 business days.</p>
                            </div>
                        </div>
                    </div>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4 mt-8">Exchanges</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        Need a different size or color? We offer free exchanges within 30 days of delivery. Simply contact us 
                        to initiate an exchange, and we'll send you the new item once we receive your return.
                    </p>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4 mt-8">Non-Returnable Items</h2>
                    <p class="text-gray-700 mb-4 leading-relaxed">
                        The following items cannot be returned:
                    </p>
                    <ul class="list-disc list-inside space-y-2 text-gray-700 ml-4 mb-6">
                        <li>Items that have been worn, washed, or damaged</li>
                        <li>Items without original tags or packaging</li>
                        <li>Items returned after 30 days</li>
                        <li>Gift cards and promotional items</li>
                    </ul>

                    <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4 mt-8">Refund Processing</h2>
                    <p class="text-gray-700 mb-6 leading-relaxed">
                        Refunds will be processed to the original payment method within 5-7 business days after we receive 
                        and inspect your return. Shipping costs are non-refundable unless the item was defective or incorrect.
                    </p>

                    <div class="bg-gray-50 rounded-lg p-6 mt-8">
                        <h3 class="font-semibold text-gray-900 mb-2">Need Help?</h3>
                        <p class="text-gray-700 mb-4">
                            If you have any questions about returns or exchanges, please don't hesitate to contact us.
                        </p>
                        <a href="{{ route('pages.contact') }}" class="inline-flex items-center gap-2 text-primary font-semibold hover:text-primary-dark transition">
                            Contact Customer Service
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

