@extends('layouts.app')

@section('title', 'FAQs')

@section('content')
<div class="min-h-screen bg-gray-50">
    <!-- Hero Section -->
    <section class="text-white py-16 md:py-24" style="background: linear-gradient(135deg, {{ $primaryColor ?? '#ff5349' }} 0%, {{ $primaryColor ?? '#ff5349' }}dd 100%);">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center max-w-3xl mx-auto">
                <h1 class="text-4xl md:text-5xl lg:text-6xl font-black mb-6 text-white">Frequently Asked Questions</h1>
                <p class="text-xl md:text-2xl text-white/90 leading-relaxed">
                    Find answers to common questions about shopping with us
                </p>
            </div>
        </div>
    </section>

    <!-- Main Content -->
    <section class="py-12 md:py-16">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="space-y-4">
                <!-- FAQ Item 1 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">How do I place an order?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Simply browse our products, add items to your cart, and proceed to checkout. You can shop as a guest 
                        or create an account for faster checkout and order tracking.
                    </p>
                </div>

                <!-- FAQ Item 2 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">What payment methods do you accept?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        We accept all major credit cards, debit cards, and cash on delivery. All payments are processed securely 
                        through our payment gateway.
                    </p>
                </div>

                <!-- FAQ Item 3 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">How long does shipping take?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Standard shipping typically takes 5-7 business days. Express shipping options are available at checkout 
                        for faster delivery. You'll receive a tracking number once your order ships.
                    </p>
                </div>

                <!-- FAQ Item 4 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">Can I track my order?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Yes! Once your order ships, you'll receive an email with a tracking number. You can also track your order 
                        by logging into your account and visiting the "My Orders" section.
                    </p>
                </div>

                <!-- FAQ Item 5 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">What is your return policy?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        We offer a 30-day return policy. Items must be unworn, unwashed, and in original condition with tags attached. 
                        Please see our <a href="{{ route('pages.returns') }}" class="text-primary hover:text-primary-dark underline">Returns & Exchanges</a> page for more details.
                    </p>
                </div>

                <!-- FAQ Item 6 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">How do I exchange an item?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        To exchange an item, contact our customer service team within 30 days of delivery. We'll provide you with 
                        a return label and process your exchange once we receive the original item.
                    </p>
                </div>

                <!-- FAQ Item 7 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">Do you ship internationally?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Currently, we ship to select countries. Please check the shipping options at checkout to see if we deliver 
                        to your location. International shipping times and costs may vary.
                    </p>
                </div>

                <!-- FAQ Item 8 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">How do I know what size to order?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        We provide detailed size charts for all products. Check the product page for size information, or visit our 
                        <a href="{{ route('pages.size-guide') }}" class="text-primary hover:text-primary-dark underline">Size Guide</a> page for comprehensive sizing information.
                    </p>
                </div>

                <!-- FAQ Item 9 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">Can I cancel my order?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Orders can be cancelled within 24 hours of placement, provided they haven't been shipped yet. Contact our 
                        customer service team immediately if you need to cancel your order.
                    </p>
                </div>

                <!-- FAQ Item 10 -->
                <div class="bg-white rounded-xl shadow-lg p-6 md:p-8">
                    <h3 class="text-xl md:text-2xl font-bold text-gray-900 mb-3">How do I create an account?</h3>
                    <p class="text-gray-700 leading-relaxed">
                        Click on "Register" in the top navigation, fill in your details, verify your email, and you're all set! 
                        Having an account allows you to track orders, save addresses, and enjoy a faster checkout experience.
                    </p>
                </div>
            </div>

            <!-- Still Have Questions -->
            <div class="mt-12 bg-white rounded-xl shadow-lg p-8 md:p-10 text-center">
                <h2 class="text-2xl md:text-3xl font-bold text-gray-900 mb-4">Still Have Questions?</h2>
                <p class="text-gray-600 mb-6">
                    Can't find the answer you're looking for? Our customer service team is here to help!
                </p>
                <a href="{{ route('pages.contact') }}" class="inline-flex items-center gap-2 bg-primary text-white px-8 py-4 rounded-lg font-bold hover:bg-primary-dark transition shadow-lg hover:shadow-xl">
                    Contact Us
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
        </div>
    </section>
</div>
@endsection

