<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', $siteTitle ?? 'Vibrant Vogue') - Fashion Shopping</title>
    
    <!-- Favicon -->
    @if(isset($siteFavicon) && $siteFavicon)
        <link rel="icon" type="image/x-icon" href="{{ productImageUrl($siteFavicon ?? '') }}">
    @endif
    
    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;600;700&family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
        }
        .font-display {
            font-family: 'Playfair Display', serif;
        }
        /* Custom Primary Color */
        @php
            $primary = $primaryColor ?? '#ff5349';
            // Calculate darker version (reduce RGB by 20%)
            $hex = str_replace('#', '', $primary);
            $r = max(0, min(255, hexdec(substr($hex, 0, 2)) - 20));
            $g = max(0, min(255, hexdec(substr($hex, 2, 2)) - 20));
            $b = max(0, min(255, hexdec(substr($hex, 4, 2)) - 20));
            $primaryDark = '#' . str_pad(dechex($r), 2, '0', STR_PAD_LEFT) . str_pad(dechex($g), 2, '0', STR_PAD_LEFT) . str_pad(dechex($b), 2, '0', STR_PAD_LEFT);
            // Calculate lighter version (add to RGB)
            $r2 = min(255, hexdec(substr($hex, 0, 2)) + 200);
            $g2 = min(255, hexdec(substr($hex, 2, 2)) + 200);
            $b2 = min(255, hexdec(substr($hex, 4, 2)) + 200);
            $primaryLight = '#' . str_pad(dechex($r2), 2, '0', STR_PAD_LEFT) . str_pad(dechex($g2), 2, '0', STR_PAD_LEFT) . str_pad(dechex($b2), 2, '0', STR_PAD_LEFT);
        @endphp
        .bg-primary { background-color: {{ $primary }}; }
        .text-primary { color: {{ $primary }}; }
        .border-primary { border-color: {{ $primary }}; }
        .hover\:bg-primary:hover { background-color: {{ $primary }}; }
        .hover\:text-primary:hover { color: {{ $primary }}; }
        .focus\:ring-primary:focus { --tw-ring-color: {{ $primary }}; }
        .bg-primary-dark { background-color: {{ $primaryDark }}; }
        .hover\:bg-primary-dark:hover { background-color: {{ $primaryDark }}; }
        .bg-primary-light { background-color: {{ $primaryLight }}; }
        .hover\:bg-primary-light:hover { background-color: {{ $primaryLight }}; }
        /* Logo outline effect */
        .logo-outline {
            color: {{ $primary }};
            -webkit-text-stroke: initial;
            text-shadow: none;
        }
    </style>
    
    @stack('styles')
</head>
<body class="bg-gray-50">
    @if(session('impersonating'))
    <!-- Impersonation Banner -->
    <div class="bg-yellow-500 text-black py-3 px-4 text-center font-bold text-sm md:text-base z-50 relative">
        <div class="max-w-7xl mx-auto flex flex-col md:flex-row items-center justify-between gap-3">
            <div class="flex items-center gap-2 flex-1 justify-center">
                <svg class="w-5 h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"/>
                </svg>
                <span class="text-center">You are viewing as: <strong>{{ auth()->user()->name }}</strong> <span class="hidden sm:inline">({{ auth()->user()->email }})</span></span>
            </div>
            <form action="{{ route('admin.users.stopImpersonate') }}" method="POST" class="md:ml-4">
                @csrf
                <button type="submit" class="bg-black text-white px-4 py-2 rounded-md hover:bg-gray-800 transition font-semibold text-sm whitespace-nowrap">
                    Stop Impersonating
                </button>
            </form>
        </div>
    </div>
    @endif
    <!-- Notification Toast - Hidden by default, shows when item is added to cart -->
    <div id="notification-toast" class="fixed top-20 right-2 sm:right-4 z-50 transform translate-x-full transition-transform duration-300 ease-in-out opacity-0 pointer-events-none">
        <div class="bg-green-500 text-white px-4 sm:px-6 py-3 sm:py-4 rounded-lg shadow-lg flex items-center gap-3 min-w-[250px] sm:min-w-[300px] max-w-[calc(100vw-1rem)]">
            <svg class="w-6 h-6 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
            </svg>
            <div>
                <p class="font-semibold" id="notification-message">Item added to cart!</p>
            </div>
        </div>
    </div>
    <!-- Jumia-Style Header -->
    <header class="w-full font-sans sticky top-0 z-[55]">
        <!-- Top Bar (Desktop) -->
        <div class="hidden md:flex bg-[#1a1a1a] text-white h-[72px] items-center px-4 lg:px-8 justify-between gap-4">
            <!-- Logo -->
            <a href="{{ route('home') }}" class="flex-shrink-0">
                 @if(isset($siteLogo) && $siteLogo)
                    <img src="{{ productImageUrl($siteLogo ?? '') }}" alt="{{ $siteTitle ?? 'TrendzTrade' }}" class="h-10 object-contain">
                @else
                    <span class="text-2xl font-bold text-white">Trendz<span style="color: {{ $primaryColor ?? '#ff5349' }};">Trade</span></span>
                @endif
            </a>

            <!-- Location -->
            <div class="relative group cursor-pointer flex items-center gap-2 text-xs lg:text-sm whitespace-nowrap min-w-0">
                <div class="bg-white/10 rounded-full p-1.5">
                    <svg class="w-4 h-4 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/></svg>
                </div>
                <div class="flex flex-col leading-tight">
                    <span class="text-gray-400 text-[10px]">Deliver to</span>
                    <span class="font-bold" id="location-selector-text">Detecting location...</span>
<script>
window.addEventListener('DOMContentLoaded', () => {
  if (navigator.geolocation) {
    navigator.geolocation.getCurrentPosition(async function(position) {
      const { latitude, longitude } = position.coords;
      const apiKey = '{{ config('app.google_api_key') }}';
      try {
        const gmRes = await fetch(`https://maps.googleapis.com/maps/api/geocode/json?latlng=${latitude},${longitude}&key=${apiKey}`);
        const gmData = await gmRes.json();
        let locationText = 'your area';
        if (gmData.results && gmData.results.length > 0) {
          locationText = gmData.results[0].formatted_address;
        }
        document.getElementById('location-selector-text').textContent = locationText;
      } catch {
        document.getElementById('location-selector-text').textContent = 'Detected, but unknown area';
      }
    }, function() {
      document.getElementById('location-selector-text').textContent = 'Location blocked';
    });
  } else {
    document.getElementById('location-selector-text').textContent = 'No location support';
  }
});
</script>
                </div>
            </div>

            <!-- Search Bar -->
            <div class="flex-1 max-w-2xl">
                 <form action="{{ route('products.index') }}" method="GET" class="flex w-full">
                    <input type="text" name="search" placeholder="Search products..." value="{{ request('search') }}" class="flex-1 h-10 px-4 text-gray-900 text-sm focus:outline-none border-none rounded-l">
                    <button type="submit" class="h-10 px-6 text-white font-bold transition hover:opacity-90 rounded-r flex items-center justify-center" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                        SEARCH
                    </button>
                </form>
            </div>

            <!-- Right Actions -->
            <div class="flex items-center gap-4 lg:gap-6 text-sm">
                <!-- Currency -->
                <div class="relative group cursor-pointer flex items-center gap-1 pb-2" id="currencySelectorHeader">
                    <span>{{ getCurrentCurrency() }}</span>
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>
                    <!-- Dropdown -->
                     <div class="absolute top-full right-0 pt-2 w-32 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition z-50">
                        <div class="bg-white text-gray-800 rounded shadow-lg py-1">
                        @foreach($supportedCurrencies as $currency)
                            <button onclick="changeCurrency('{{ $currency }}')" class="block w-full text-left px-4 py-2 hover:bg-gray-100 {{ $currentCurrency === $currency ? 'font-bold' : '' }}">
                                {{ $currency }}
                            </button>
                        @endforeach
                        </div>
                    </div>
                </div>

                <!-- Account -->
                <div class="relative group cursor-pointer flex items-center gap-2 pb-2">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/></svg>
                    <div class="flex flex-col leading-tight">
                        @auth
                            <span>Hello, {{ Auth::user()->name }}</span>
                        @else
                            <span>Hello, Sign In</span>
                        @endauth
                        <span class="font-bold flex items-center gap-1">Account <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg></span>
                    </div>
                    <!-- Dropdown -->
                     <div class="absolute top-full right-0 pt-2 w-56 opacity-0 invisible group-hover:opacity-100 group-hover:visible transition z-50">
                        <div class="bg-white text-gray-800 rounded shadow-lg py-2 border border-gray-100">
                        @auth
                            @if(auth()->user()->is_admin)
                                <a href="{{ route('admin.dashboard') }}" class="block px-4 py-2 hover:bg-gray-100 font-bold text-primary border-b border-gray-100">Admin Dashboard</a>
                            @endif

                            @if(auth()->user()->is_store_owner)
                                @if(auth()->user()->store)
                                    <a href="{{ route('store.dashboard') }}" class="block px-4 py-2 hover:bg-gray-100 font-bold text-orange-600 border-b border-gray-100">Store Dashboard</a>
                                @else
                                    <a href="{{ route('store.register') }}" class="block px-4 py-2 hover:bg-gray-100 font-bold text-orange-600 border-b border-gray-100">Complete Store Setup</a>
                                @endif
                            @endif

                            <a href="{{ route('customer.dashboard') }}" class="block px-4 py-2 hover:bg-gray-100">My Account</a>
                            <a href="{{ route('profile.index') }}" class="block px-4 py-2 hover:bg-gray-100">My Profile</a>
                            <a href="{{ route('orders.index') }}" class="block px-4 py-2 hover:bg-gray-100">My Orders</a>
                            
                             <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="block w-full text-left px-4 py-2 hover:bg-gray-100 text-red-500 font-medium border-t border-gray-100 mt-1">Logout</button>
                            </form>
                        @else
                            <div class="px-4 py-2 border-b">
                                <a href="{{ route('login') }}" class="block w-full bg-primary text-white text-center py-2 rounded font-bold hover:opacity-90 transition" style="background-color: {{ $primaryColor ?? '#ff5349' }};">SIGN IN</a>
                            </div>
                            <a href="{{ route('register') }}" class="block px-4 py-2 hover:bg-gray-100 text-center text-primary font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">CREATE AN ACCOUNT</a>
                        @endauth
                        </div>
                    </div>
                </div>

                <!-- Wishlist -->
                <a href="{{ route('customer.wishlist') }}" class="flex items-center gap-2 hover:text-primary transition">
                     <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/></svg>
                     <span class="hidden xl:inline">Wishlist</span>
                </a>

                <!-- Cart -->
                <a href="{{ route('cart.index') }}" class="flex items-center gap-2 hover:text-primary transition relative">
                    <div class="relative">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"/></svg>
                        @php
                            if (auth()->check()) {
                                $cartCount = auth()->user()->cartItems()->whereHas('product')->count();
                            } else {
                                $sessionCart = session('cart', []);
                                $cartCount = 0;
                                foreach ($sessionCart as $item) {
                                    if (\App\Models\Product::find($item['product_id'] ?? null)) {
                                        $cartCount++;
                                    }
                                }
                            }
                        @endphp
                        <span class="absolute -top-2 -right-2 bg-primary text-white text-[10px] font-bold rounded-full w-4 h-4 flex items-center justify-center" style="background-color: {{ $primaryColor ?? '#ff5349' }};">{{ $cartCount ?? 0 }}</span>
                    </div>
                    <span class="hidden xl:inline">Cart</span>
                </a>
            </div>
        </div>

        <!-- Navigation Bar (Desktop) -->
        <div class="hidden md:block bg-[#2d2d2d] border-t border-gray-700">
            <div class="container mx-auto px-4 lg:px-8">
                <ul class="flex items-center gap-6 text-[13px] font-bold text-white py-2 overflow-x-auto whitespace-nowrap scrollbar-hide uppercase tracking-wide">
                    <li><a href="{{ route('home') }}" class="hover:text-primary transition">Home</a></li>
                    @foreach($navCategories ?? [] as $category)
                        <li><a href="{{ route('products.index', ['category' => $category->id]) }}" class="hover:text-primary transition">{{ strtoupper($category->name) }}</a></li>
                    @endforeach
                </ul>
            </div>
        </div>

        <!-- Mobile Header (Simplified) -->
        <div class="md:hidden bg-[#1a1a1a] text-white p-3 flex items-center justify-between shadow-md sticky top-0 z-50">
             <!-- Hamburger -->
             <button id="mobileMenuButton" type="button" class="text-white hover:text-primary transition flex items-center justify-center w-10 h-10 -ml-2" onclick="toggleMobileMenu()" aria-label="Toggle menu">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16"/>
                </svg>
            </button>
             
             <!-- Logo -->
             <a href="{{ route('home') }}" class="flex items-center">
                 @if(isset($siteLogo) && $siteLogo)
                    <img src="{{ productImageUrl($siteLogo ?? '') }}" alt="{{ $siteTitle ?? 'TrendzTrade' }}" class="h-8 object-contain">
                @else
                    <span class="text-lg font-bold text-white">Trendz<span style="color: {{ $primaryColor ?? '#ff5349' }};">Trade</span></span>
                @endif
             </a>

             <!-- Cart -->
             <a href="{{ route('cart.index') }}" class="relative text-white">
                 <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"/></svg>
                 <span class="absolute -top-1 -right-1 bg-primary text-white text-[10px] w-4 h-4 flex items-center justify-center rounded-full font-bold" style="background-color: {{ $primaryColor ?? '#ff5349' }};">{{ $cartCount ?? 0 }}</span>
             </a>
        </div>
        <!-- Mobile Search -->
        <div class="md:hidden bg-[#1a1a1a] p-3 pt-0 pb-3">
            <form action="{{ route('products.index') }}" class="flex shadow-sm">
                <input type="text" name="search" placeholder="Search products..." class="flex-1 h-10 px-4 rounded-l text-gray-900 focus:outline-none text-sm">
                <button type="submit" class="h-10 px-4 text-white rounded-r font-bold flex items-center justify-center" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/></svg>
                </button>
            </form>
        </div>
    </header>
    
    <!-- Mobile Menu Backdrop -->
    <div id="mobileMenuBackdrop" class="hidden fixed top-16 left-0 right-0 bottom-0 bg-black bg-opacity-50 z-40 md:hidden" onclick="closeMobileMenu()"></div>
    
    <!-- Mobile Menu Dropdown -->
    <div id="mobileMenu" class="hidden fixed left-0 top-16 bottom-0 w-4/5 max-w-sm bg-white border-r border-gray-200 shadow-2xl z-[60] flex flex-col overflow-y-auto md:hidden">
            <!-- Search Bar -->
            <div class="px-4 py-4 border-b border-gray-200 bg-white flex-shrink-0">
                <button onclick="toggleSearchModal()" class="w-full flex items-center px-4 py-3 bg-gray-50 rounded-lg border border-gray-200 hover:border-gray-300 transition-colors">
                    <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                    </svg>
                    <span class="text-gray-500 text-sm">Search for products</span>
                </button>
            </div>
            
            <!-- Menu Items -->
            <div class="py-2 bg-white flex-1">
                    <a href="{{ route('home') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                        <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                        </svg>
                        <span class="flex-1">HOME</span>
                    </a>
                    <a href="{{ route('products.index') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                        <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                        </svg>
                        <span class="flex-1">SHOP</span>
                    </a>
                    @foreach($navCategories ?? [] as $category)
                        <a href="{{ route('products.index', ['category' => $category->id]) }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                            <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                            </svg>
                            <span class="flex-1">{{ strtoupper($category->name) }}</span>
                        </a>
                    @endforeach
                @auth
                    <a href="{{ auth()->user()->is_admin ? route('admin.dashboard') : route('customer.dashboard') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                        <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        <span class="flex-1">Hi, {{ auth()->user()->name }}</span>
                    </a>
                    @if(!auth()->user()->is_admin)
                        <a href="{{ route('customer.dashboard') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                            <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                            </svg>
                            <span class="flex-1">Dashboard</span>
                        </a>
                        <a href="{{ route('customer.wishlist') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                            <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                            </svg>
                            <span class="flex-1">Wishlist</span>
                        </a>
                        <a href="{{ route('orders.index') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                            <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                            </svg>
                            <span class="flex-1">My Orders</span>
                        </a>
                        <a href="{{ route('customer.addresses') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                            <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <span class="flex-1">My Addresses</span>
                        </a>
                    @endif
                    <a href="{{ route('profile.index') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                        <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                        </svg>
                        <span class="flex-1">Profile Settings</span>
                    </a>
                @else
                    <a href="{{ route('login') }}" onclick="closeMobileMenu()" class="flex items-center group text-gray-900 hover:text-primary hover:bg-gray-50 transition-all duration-200 text-sm font-medium py-3.5 px-6 border-b border-gray-100 bg-white">
                        <svg class="w-5 h-5 mr-4 text-gray-400 group-hover:text-primary transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"/>
                        </svg>
                        <span class="flex-1">LOGIN / REGISTER</span>
                    </a>
                @endauth
                </div>
    </div>

    <!-- Admin Navigation -->
    @auth
        @if(auth()->user()->is_admin && request()->is('admin*'))
            <nav class="bg-gray-800 border-b border-gray-700 sticky top-16 z-40">
                <div class="max-w-7xl mx-auto px-2 sm:px-4 lg:px-8">
                    <div class="flex items-center space-x-0.5 sm:space-x-1 h-12 overflow-x-auto scrollbar-hide">
                        <a href="{{ route('admin.dashboard') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.dashboard') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Dashboard
                        </a>
                        <a href="{{ route('admin.orders.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.orders.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Orders
                        </a>
                        <a href="{{ route('admin.products.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.products.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Products
                        </a>
                        <a href="{{ route('admin.categories.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.categories.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Categories
                        </a>
                        <a href="{{ route('admin.users.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.users.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Clients
                        </a>
                        <a href="{{ route('admin.stores.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->is('admin/stores*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Stores
                        </a>
                        <a href="{{ route('admin.sliders.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.sliders.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Sliders
                        </a>
                        <a href="{{ route('admin.analytics.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.analytics.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Analytics
                        </a>
                        <a href="{{ route('admin.email-marketing.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.email-marketing.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Email Marketing
                        </a>
                        <a href="{{ route('admin.settings.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('admin.settings.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Settings
                        </a>
                        <a href="{{ route('profile.index') }}" 
                           class="px-2 sm:px-4 py-2 text-xs sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('profile.*') ? 'bg-gray-700 text-white' : 'text-gray-300 hover:text-white hover:bg-gray-700' }} rounded transition flex-shrink-0">
                            Profile
                        </a>
                    </div>
                </div>
            </nav>
            <style>
                .scrollbar-hide {
                    -ms-overflow-style: none;
                    scrollbar-width: none;
                }
                .scrollbar-hide::-webkit-scrollbar {
                    display: none;
                }
            </style>
        @endif
    @endauth

    <!-- Customer Navigation -->
    @auth
        @if(!auth()->user()->is_admin && (request()->routeIs('customer.*') || request()->routeIs('orders.*') || request()->routeIs('profile.*')))
            <nav class="bg-primary border-b border-primary-dark sticky top-16 z-40">
                <div class="max-w-7xl mx-auto px-3 sm:px-4 lg:px-8">
                    <div class="flex items-center space-x-1 sm:space-x-2 h-14 sm:h-12 overflow-x-auto scrollbar-hide">
                        <a href="{{ route('customer.dashboard') }}" 
                           class="flex items-center gap-1.5 sm:gap-2 px-3 sm:px-4 py-2.5 sm:py-2 text-sm sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('customer.dashboard') ? 'bg-white/20 text-white' : 'text-white/90 hover:text-white hover:bg-white/10' }} rounded-lg sm:rounded transition flex-shrink-0">
                            <svg class="w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6"/>
                            </svg>
                            <span class="hidden sm:inline">Dashboard</span>
                            <span class="sm:hidden">Home</span>
                        </a>
                        <a href="{{ route('customer.wishlist') }}" 
                           class="flex items-center gap-1.5 sm:gap-2 px-3 sm:px-4 py-2.5 sm:py-2 text-sm sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('customer.wishlist*') ? 'bg-white/20 text-white' : 'text-white/90 hover:text-white hover:bg-white/10' }} rounded-lg sm:rounded transition flex-shrink-0">
                            <svg class="w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                            </svg>
                            <span>Wishlist</span>
                        </a>
                        <a href="{{ route('orders.index') }}" 
                           class="flex items-center gap-1.5 sm:gap-2 px-3 sm:px-4 py-2.5 sm:py-2 text-sm sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('orders.*') ? 'bg-white/20 text-white' : 'text-white/90 hover:text-white hover:bg-white/10' }} rounded-lg sm:rounded transition flex-shrink-0">
                            <svg class="w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                            </svg>
                            <span class="hidden sm:inline">My Orders</span>
                            <span class="sm:hidden">Orders</span>
                        </a>
                        <a href="{{ route('customer.addresses') }}" 
                           class="flex items-center gap-1.5 sm:gap-2 px-3 sm:px-4 py-2.5 sm:py-2 text-sm sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('customer.addresses*') ? 'bg-white/20 text-white' : 'text-white/90 hover:text-white hover:bg-white/10' }} rounded-lg sm:rounded transition flex-shrink-0">
                            <svg class="w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <span class="hidden sm:inline">My Addresses</span>
                            <span class="sm:hidden">Addresses</span>
                        </a>
                        <a href="{{ route('profile.index') }}" 
                           class="flex items-center gap-1.5 sm:gap-2 px-3 sm:px-4 py-2.5 sm:py-2 text-sm sm:text-sm font-medium whitespace-nowrap {{ request()->routeIs('profile.*') ? 'bg-white/20 text-white' : 'text-white/90 hover:text-white hover:bg-white/10' }} rounded-lg sm:rounded transition flex-shrink-0">
                            <svg class="w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                            </svg>
                            <span class="hidden sm:inline">Profile Settings</span>
                            <span class="sm:hidden">Profile</span>
                        </a>
                    </div>
                </div>
            </nav>
            <style>
                .scrollbar-hide {
                    -ms-overflow-style: none;
                    scrollbar-width: none;
                }
                .scrollbar-hide::-webkit-scrollbar {
                    display: none;
                }
            </style>
        @endif
    @endauth

    <!-- Flash Messages -->
    @if(session('success'))
        <div id="success-message" class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    @if(session('error'))
        <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4" role="alert">
            <p>{{ session('error') }}</p>
        </div>
    @endif

    <!-- Main Content -->
    <main>
        @yield('content')
    </main>

    <!-- Newsletter Section -->
    <section class="py-6 md:py-8 bg-black border-b border-gray-800">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center mb-4 md:mb-6">
                <!-- Title -->
                <h2 class="text-xl sm:text-2xl md:text-3xl font-black text-white mb-2">
                    Stay in the Loop
                </h2>
                
                <!-- Description -->
                <p class="text-white/80 text-xs sm:text-sm max-w-2xl mx-auto">
                    Subscribe to our newsletter and be the first to know about new arrivals, exclusive offers, and fashion trends
                </p>
            </div>
            
            <!-- Newsletter Form -->
            <div class="max-w-2xl mx-auto">
                <form id="newsletter-form" action="{{ route('newsletter.subscribe') }}" method="POST" class="flex flex-col sm:flex-row gap-3">
                    @csrf
                    
                    <!-- Name Input (Optional, hidden by default, can be shown if needed) -->
                    <input type="hidden" name="name" id="newsletter-name" value="">
                    
                    <!-- Email Input -->
                    <div class="flex-1">
                        <input 
                            type="email" 
                            name="email" 
                            id="newsletter-email" 
                            placeholder="Enter your email address"
                            required
                            class="w-full px-4 sm:px-5 py-2.5 sm:py-3 rounded-lg text-gray-900 text-sm sm:text-base font-medium placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-primary transition shadow-lg"
                        >
                        <div id="newsletter-error" class="mt-2 text-sm text-white/90 hidden"></div>
                    </div>
                    
                    <!-- Submit Button -->
                    <button 
                        type="submit" 
                        id="newsletter-submit"
                        class="px-6 sm:px-8 py-2.5 sm:py-3 bg-primary text-white rounded-lg font-bold text-sm sm:text-base hover:bg-primary-dark transition shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 whitespace-nowrap flex items-center justify-center gap-2"
                    >
                        <span id="newsletter-submit-text">Subscribe</span>
                        <svg id="newsletter-submit-icon" class="w-5 h-5 hidden" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                        </svg>
                        <svg id="newsletter-loading-icon" class="w-5 h-5 hidden animate-spin" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                    </button>
                </form>
                
                <!-- Success Message -->
                <div id="newsletter-success" class="mt-3 p-3 bg-white/10 backdrop-blur-sm rounded-lg text-white text-center hidden">
                    <p class="font-semibold text-sm"></p>
                </div>
                
                <!-- Privacy Note -->
                <p class="mt-3 text-center text-white/70 text-xs">
                    We respect your privacy. Unsubscribe at any time.
                </p>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="bg-black text-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10 md:py-12">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-8 md:gap-10">
                <!-- Brand Column -->
                <div class="sm:col-span-2 lg:col-span-1">
                    <div class="mb-4">
                        @if(isset($siteLogo) && $siteLogo)
                            <img src="{{ productImageUrl($siteLogo ?? '') }}" 
                                 alt="{{ $siteTitle ?? 'Vibrant Vogue' }}" 
                                 class="h-10 md:h-12 w-auto"
                                 onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                            <h3 class="font-display text-2xl md:text-3xl font-bold" style="display: none;">
                                {{ $siteTitle ?? 'Vibrant Vogue' }}
                            </h3>
                        @else
                            <h3 class="font-display text-2xl md:text-3xl font-bold">
                                {{ $siteTitle ?? 'Vibrant Vogue' }}
                            </h3>
                        @endif
                    </div>
                    <p class="text-gray-400 text-sm md:text-base mb-4 max-w-xs">
                        Your destination for elegant fashion and style. Discover the latest trends and timeless pieces.
                    </p>
                    <!-- Social Media Icons -->
                    <div class="flex items-center gap-3 mt-6">
                        @if(!empty($facebookUrl))
                            <a href="{{ $facebookUrl }}" target="_blank" rel="noopener noreferrer" 
                               class="w-10 h-10 bg-gray-900 rounded-full flex items-center justify-center hover:bg-primary transition group">
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-white transition" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </a>
                        @endif
                        @if(!empty($instagramUrl))
                            <a href="{{ $instagramUrl }}" target="_blank" rel="noopener noreferrer" 
                               class="w-10 h-10 bg-gray-900 rounded-full flex items-center justify-center hover:bg-primary transition group">
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-white transition" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                                </svg>
                            </a>
                        @endif
                        @if(!empty($whatsappUrl))
                            <a href="{{ $whatsappUrl }}" target="_blank" rel="noopener noreferrer" 
                               class="w-10 h-10 bg-gray-900 rounded-full flex items-center justify-center hover:bg-primary transition group">
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-white transition" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/>
                                </svg>
                            </a>
                        @endif
                        @if(!empty($youtubeUrl))
                            <a href="{{ $youtubeUrl }}" target="_blank" rel="noopener noreferrer" 
                               class="w-10 h-10 bg-gray-900 rounded-full flex items-center justify-center hover:bg-primary transition group">
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-white transition" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                                </svg>
                            </a>
                        @endif
                        @if(!empty($tiktokUrl))
                            <a href="{{ $tiktokUrl }}" target="_blank" rel="noopener noreferrer" 
                               class="w-10 h-10 bg-gray-900 rounded-full flex items-center justify-center hover:bg-primary transition group">
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-white transition" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M19.59 6.69a4.83 4.83 0 01-3.77-4.25V2h-3.45v13.67a2.89 2.89 0 01-5.2 1.74 2.89 2.89 0 012.31-4.64 2.93 2.93 0 01.88.13V9.4a6.84 6.84 0 00-1-.05A6.33 6.33 0 005 20.1a6.34 6.34 0 0010.86-4.43v-7a8.16 8.16 0 004.77 1.52v-3.4a4.85 4.85 0 01-1-.1z"/>
                                </svg>
                            </a>
                        @endif
                        @if(!empty($snapchatUrl))
                            <a href="{{ $snapchatUrl }}" target="_blank" rel="noopener noreferrer" 
                               class="w-10 h-10 bg-gray-900 rounded-full flex items-center justify-center hover:bg-primary transition group">
                                <svg class="w-5 h-5 text-gray-400 group-hover:text-white transition" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M12.166 2c-5.5 0-9.955 4.373-9.955 9.766 0 4.305 2.69 7.98 6.5 9.45-.09-.81-.16-2.08.035-2.84.18-.77 1.15-5.1 1.15-5.1s-.3-.6-.3-1.48c0-1.38.8-2.42 1.8-2.42.85 0 1.26.64 1.26 1.4 0 .85-.54 2.1-.82 3.27-.23 1 .48 1.8 1.48 1.8 1.78 0 3.15-1.87 3.15-4.57 0-2.38-1.72-4.06-4.18-4.06-2.84 0-4.5 2.13-4.5 4.33 0 .86.33 1.78.74 2.28.08.1.09.19.07.29-.07.31-.24 1-.27 1.14-.04.19-.14.23-.33.14-1.24-.58-2.02-2.4-2.02-3.86 0-3.15 2.29-6.05 6.6-6.05 3.46 0 6.16 2.47 6.16 5.76 0 3.44-2.17 6.22-5.19 6.22-1.01 0-1.96-.53-2.29-1.23l-.62 2.38c-.22.87-.82 1.96-1.24 2.62.9.27 1.85.42 2.83.42 5.5 0 9.96-4.37 9.96-9.77C22.126 6.373 17.666 2 12.166 2z"/>
                                </svg>
                            </a>
                        @endif
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div>
                    <h4 class="font-semibold text-white mb-4 text-base md:text-lg">Quick Links</h4>
                    <ul class="space-y-2.5 text-gray-400 text-sm md:text-base">
                        <li><a href="{{ route('home') }}" class="hover:text-white transition">Home</a></li>
                        <li><a href="{{ route('products.index') }}" class="hover:text-white transition">All Products</a></li>
                        <li><a href="{{ route('products.index', ['featured' => 1]) }}" class="hover:text-white transition">Featured Products</a></li>
                        @auth
                            <li><a href="{{ route('customer.dashboard') }}" class="hover:text-white transition">My Account</a></li>
                            <li><a href="{{ route('orders.index') }}" class="hover:text-white transition">My Orders</a></li>
                        @else
                            <li><a href="{{ route('login') }}" class="hover:text-white transition">Login</a></li>
                            <li><a href="{{ route('register') }}" class="hover:text-white transition">Register</a></li>
                        @endauth
                    </ul>
                </div>
                
                <!-- Customer Service -->
                <div>
                    <h4 class="font-semibold text-white mb-4 text-base md:text-lg">Customer Service</h4>
                    <ul class="space-y-2.5 text-gray-400 text-sm md:text-base">
                        <li><a href="{{ route('pages.contact') }}" class="hover:text-white transition">Contact Us</a></li>
                        <li><a href="{{ route('pages.returns') }}" class="hover:text-white transition">Returns & Exchanges</a></li>
                        <li><a href="{{ route('pages.faqs') }}" class="hover:text-white transition">FAQs</a></li>
                        <li><a href="{{ route('pages.size-guide') }}" class="hover:text-white transition">Size Guide</a></li>
                    </ul>
                </div>
                
                <!-- Company -->
                <div>
                    <h4 class="font-semibold text-white mb-4 text-base md:text-lg">Company</h4>
                    <ul class="space-y-2.5 text-gray-400 text-sm md:text-base">
                        <li><a href="{{ route('pages.about') }}" class="hover:text-white transition">About Us</a></li>
                        <li><a href="{{ route('pages.privacy') }}" class="hover:text-white transition">Privacy Policy</a></li>
                        <li><a href="{{ route('pages.terms') }}" class="hover:text-white transition">Terms & Conditions</a></li>
                        <li><a href="{{ route('store.register') }}" class="hover:text-white transition font-bold text-primary"
   @auth
    @if(auth()->user()->is_store_owner && auth()->user()->store)
        href="{{ route('store.dashboard') }}"
    @else
        href="{{ route('store.register') }}"
    @endif
   @endauth
>Sell On Trendz Trade</a></li>
                    </ul>
                </div>
            </div>
            
            <!-- Bottom Bar -->
            <div class="border-t border-gray-800 mt-8 md:mt-10 pt-6 md:pt-8">
                <div class="flex flex-col md:flex-row justify-between items-center gap-4 md:gap-6 text-gray-400 text-xs md:text-sm">
                    <p>&copy; {{ date('Y') }} {{ $siteTitle ?? 'Vibrant Vogue' }}. All rights reserved.</p>
                    <div class="flex items-center gap-4 md:gap-6">
                        <a href="{{ route('pages.privacy') }}" class="hover:text-white transition">Privacy</a>
                        <span class="text-gray-600">|</span>
                        <a href="{{ route('pages.terms') }}" class="hover:text-white transition">Terms</a>
                        <span class="text-gray-600">|</span>
                        <a href="{{ route('pages.about') }}" class="hover:text-white transition">About</a>
                    </div>
                </div>
                <div class="mt-6 md:mt-8 text-center text-xs md:text-sm">
                    <p class="text-white font-bold">Powered By <a href="https://wa.me/233594700200" target="_blank" rel="noopener noreferrer" class="text-primary hover:opacity-80 transition font-bold">Khofi Benson Studios</a></p>
                </div>
            </div>
        </div>
    </footer>

    @stack('scripts')
    
    <script>
        function toggleCurrencyDropdown() {
            const dropdown = document.getElementById('currencyDropdown');
            if (dropdown.classList.contains('opacity-0')) {
                dropdown.classList.remove('opacity-0', 'invisible');
                dropdown.classList.add('opacity-100', 'visible');
            } else {
                dropdown.classList.add('opacity-0', 'invisible');
                dropdown.classList.remove('opacity-100', 'visible');
            }
        }

        function toggleCurrencyDropdownMobile() {
            const dropdown = document.getElementById('currencyDropdownMobile');
            if (dropdown.classList.contains('opacity-0')) {
                dropdown.classList.remove('opacity-0', 'invisible');
                dropdown.classList.add('opacity-100', 'visible');
            } else {
                dropdown.classList.add('opacity-0', 'invisible');
                dropdown.classList.remove('opacity-100', 'visible');
            }
        }

        function changeCurrency(currency) {
            fetch('{{ route("currency.change") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({ currency: currency })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Reload page to update all prices
                    window.location.reload();
                }
            })
            .catch(error => {
                console.error('Error:', error);
            });
        }

        // Close dropdown when clicking outside
        document.addEventListener('click', function(event) {
            const selector = document.getElementById('currencySelector');
            const dropdown = document.getElementById('currencyDropdown');
            const selectorMobile = document.getElementById('currencySelectorMobile');
            const dropdownMobile = document.getElementById('currencyDropdownMobile');
            
            if (selector && !selector.contains(event.target)) {
                dropdown.classList.add('opacity-0', 'invisible');
                dropdown.classList.remove('opacity-100', 'visible');
            }
            
            if (selectorMobile && !selectorMobile.contains(event.target)) {
                dropdownMobile.classList.add('opacity-0', 'invisible');
                dropdownMobile.classList.remove('opacity-100', 'visible');
            }
        });

        // Show notification toast
        function showNotification(message) {
            const toast = document.getElementById('notification-toast');
            const messageEl = document.getElementById('notification-message');
            messageEl.textContent = message;
            
            // Show the notification
            toast.classList.remove('translate-x-full', 'opacity-0', 'pointer-events-none');
            toast.classList.add('translate-x-0', 'opacity-100');
            
            // Hide after 3 seconds
            setTimeout(() => {
                toast.classList.remove('translate-x-0', 'opacity-100');
                toast.classList.add('translate-x-full', 'opacity-0', 'pointer-events-none');
            }, 3000);
        }

        // Handle Add to Cart forms with AJAX
        document.addEventListener('DOMContentLoaded', function() {
            // Find all add to cart forms by class or by checking for product_id
            const addToCartForms = document.querySelectorAll('.add-to-cart-form, form[action*="/cart"]');
            
            addToCartForms.forEach(form => {
                // Check if this form has a product_id input (it's an add to cart form)
                const productIdInput = form.querySelector('input[name="product_id"]');
                if (!productIdInput) return; // Skip if not an add to cart form
                
                form.addEventListener('submit', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    e.stopImmediatePropagation();
                    
                    const formData = new FormData(this);
                    const submitButton = this.querySelector('button[type="submit"]');
                    const originalText = submitButton ? submitButton.textContent : '';
                    
                    // Disable button during request
                    if (submitButton) {
                        submitButton.disabled = true;
                        submitButton.textContent = 'Adding...';
                    }

                    fetch(this.action, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                            'Accept': 'application/json'
                        }
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(data => {
                        if (data.success) {
                            // Update cart count (desktop)
                            const cartCountEl = document.getElementById('cart-count');
                            if (cartCountEl) {
                                cartCountEl.textContent = data.cart_count;
                                if (data.cart_count > 0) {
                                    cartCountEl.classList.remove('hidden');
                                } else {
                                    cartCountEl.classList.add('hidden');
                                }
                            }
                            
                            // Update cart count (mobile)
                            const cartCountMobileEl = document.getElementById('cart-count-mobile');
                            if (cartCountMobileEl) {
                                cartCountMobileEl.textContent = data.cart_count;
                                if (data.cart_count > 0) {
                                    cartCountMobileEl.classList.remove('hidden');
                                } else {
                                    cartCountMobileEl.classList.add('hidden');
                                }
                            }
                            
                            // Show notification (the green checkmark at the top)
                            showNotification(data.message || 'Item added to cart!');
                        }
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        showNotification('Error adding item to cart. Please try again.');
                    })
                    .finally(() => {
                        // Re-enable button
                        if (submitButton) {
                            submitButton.disabled = false;
                            submitButton.textContent = originalText;
                        }
                    });
                    
                    return false;
                });
            });
        });

        // Search Modal Functions
        let searchTimeout;
        let currentSearchAbortController = null;

        function toggleMobileMenu() {
            const menu = document.getElementById('mobileMenu');
            const button = document.getElementById('mobileMenuButton');
            const backdrop = document.getElementById('mobileMenuBackdrop');
            
            console.log('toggleMobileMenu called', { menu, button, backdrop });
            
            if (!menu || !button) {
                console.error('Menu elements not found', { menu, button });
                return;
            }
            
            const isHidden = menu.classList.contains('hidden');
            console.log('Menu is hidden:', isHidden);
            
            if (isHidden) {
                // Open menu
                console.log('Opening menu');
                menu.classList.remove('hidden');
                menu.setAttribute('style', 'display: flex !important; visibility: visible !important; opacity: 1 !important;');
                
                if (backdrop) {
                    backdrop.classList.remove('hidden');
                    backdrop.setAttribute('style', 'display: block !important; visibility: visible !important;');
                }
                document.body.style.overflow = 'hidden';
                
                // Change icon to X
                button.innerHTML = `
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                `;
                
                console.log('Menu should be visible now', menu.style.display, menu.classList.toString());
            } else {
                // Close menu
                console.log('Closing menu');
                menu.classList.add('hidden');
                menu.setAttribute('style', 'display: none !important;');
                
                if (backdrop) {
                    backdrop.classList.add('hidden');
                    backdrop.setAttribute('style', 'display: none !important;');
                }
                document.body.style.overflow = '';
                
                // Change icon to hamburger
                button.innerHTML = `
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16"/>
                    </svg>
                `;
            }
        }
        
        // Close menu when clicking backdrop
        function closeMobileMenu() {
            const menu = document.getElementById('mobileMenu');
            const button = document.getElementById('mobileMenuButton');
            const backdrop = document.getElementById('mobileMenuBackdrop');
            if (menu && !menu.classList.contains('hidden')) {
                menu.classList.add('hidden');
                menu.style.display = 'none';
                if (backdrop) {
                    backdrop.classList.add('hidden');
                    backdrop.style.display = 'none';
                }
                document.body.style.overflow = '';
                if (button) {
                    button.innerHTML = `
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24" stroke-width="2">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16"/>
                        </svg>
                    `;
                }
            }
        }

        function toggleSearchModal() {
            const modal = document.getElementById('searchModal');
            const searchInput = document.getElementById('searchInput');
            const suggestions = document.getElementById('searchSuggestions');
            
            if (modal.classList.contains('hidden')) {
                modal.classList.remove('hidden');
                setTimeout(() => {
                    if (searchInput) {
                        searchInput.focus();
                        // Initialize search event listener if not already attached
                        initSearchAutocomplete();
                    }
                }, 100);
            } else {
                modal.classList.add('hidden');
                if (searchInput) searchInput.value = '';
                if (suggestions) suggestions.classList.add('hidden');
            }
        }

        // AJAX Search with Autocomplete
        let searchInitialized = false;
        
        function initSearchAutocomplete() {
            const searchInput = document.getElementById('searchInput');
            const suggestions = document.getElementById('searchSuggestions');
            const suggestionsList = document.getElementById('suggestionsList');
            
            if (!searchInput || !suggestions || !suggestionsList) return;
            if (searchInitialized) return; // Already initialized
            
            searchInitialized = true;
            
            searchInput.addEventListener('input', function(e) {
                const query = e.target.value.trim();
                
                // Clear previous timeout
                clearTimeout(searchTimeout);
                
                // Cancel previous request if still pending
                if (currentSearchAbortController) {
                    currentSearchAbortController.abort();
                }
                
                if (query.length < 2) {
                    suggestions.classList.add('hidden');
                    return;
                }
                
                // Debounce search - wait 300ms after user stops typing
                searchTimeout = setTimeout(() => {
                    // Show loading state
                    suggestionsList.innerHTML = '<div class="p-4 text-center text-gray-500">Searching...</div>';
                    suggestions.classList.remove('hidden');
                    
                    // Create new AbortController for this request
                    currentSearchAbortController = new AbortController();
                    
                    // Make AJAX request
                    fetch('{{ route("products.search") }}?q=' + encodeURIComponent(query), {
                        method: 'GET',
                        headers: {
                            'X-Requested-With': 'XMLHttpRequest',
                            'Accept': 'application/json'
                        },
                        signal: currentSearchAbortController.signal
                    })
                    .then(response => {
                        if (!response.ok) {
                            throw new Error('Network response was not ok');
                        }
                        return response.json();
                    })
                    .then(data => {
                        if (data.products && data.products.length > 0) {
                            suggestionsList.innerHTML = '';
                            data.products.forEach(product => {
                                const item = document.createElement('a');
                                item.href = '{{ url("/products") }}/' + product.slug;
                                item.className = 'block p-4 hover:bg-gray-50 transition cursor-pointer';
                                item.innerHTML = `
                                    <div class="flex items-center gap-4">
                                        <img src="${product.image}" alt="${product.name}" 
                                             class="w-16 h-16 object-cover rounded"
                                             onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                        <div class="flex-1">
                                            <h3 class="font-semibold text-gray-900">${product.name}</h3>
                                            <p class="text-sm text-gray-500">${product.category}</p>
                                            <p class="text-primary font-bold mt-1">${product.formatted_price || formatCurrencyPrice(product.price)}</p>
                                        </div>
                                    </div>
                                `;
                                suggestionsList.appendChild(item);
                            });
                            
                            // Add "View All Results" link
                            const viewAll = document.createElement('a');
                            viewAll.href = '{{ route("products.index") }}?search=' + encodeURIComponent(query);
                            viewAll.className = 'block p-4 bg-gray-50 hover:bg-gray-100 transition text-center font-semibold text-primary border-t-2 border-gray-200';
                            viewAll.textContent = 'View All Results';
                            suggestionsList.appendChild(viewAll);
                        } else {
                            suggestionsList.innerHTML = '<div class="p-4 text-center text-gray-500">No products found</div>';
                        }
                        suggestions.classList.remove('hidden');
                    })
                    .catch(error => {
                        if (error.name !== 'AbortError') {
                            console.error('Search error:', error);
                            suggestionsList.innerHTML = '<div class="p-4 text-center text-red-500">Error searching. Please try again.</div>';
                            suggestions.classList.remove('hidden');
                        }
                    });
                }, 300);
            });
            
            // Handle Enter key - go to products page with search
            searchInput.addEventListener('keydown', function(e) {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    const query = e.target.value.trim();
                    if (query.length >= 2) {
                        window.location.href = '{{ route("products.index") }}?search=' + encodeURIComponent(query);
                    }
                }
            });
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize search when modal is opened
            const searchModal = document.getElementById('searchModal');
            if (searchModal) {
                const observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if (!mutation.target.classList.contains('hidden')) {
                            setTimeout(initSearchAutocomplete, 100);
                        }
                    });
                });
                observer.observe(searchModal, { attributes: true, attributeFilter: ['class'] });
            }
        });

        // Close search modal when clicking outside
        document.addEventListener('click', function(event) {
            const modal = document.getElementById('searchModal');
            const modalContent = modal ? modal.querySelector('.bg-white') : null;
            
            if (modal && modalContent && !modalContent.contains(event.target) && !event.target.closest('button[onclick="toggleSearchModal()"]')) {
                if (!modal.classList.contains('hidden')) {
                    modal.classList.add('hidden');
                    document.getElementById('searchInput').value = '';
                    document.getElementById('searchSuggestions').classList.add('hidden');
                }
            }
        });

        // Close search modal with Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                const modal = document.getElementById('searchModal');
                if (modal && !modal.classList.contains('hidden')) {
                    modal.classList.add('hidden');
                    document.getElementById('searchInput').value = '';
                    document.getElementById('searchSuggestions').classList.add('hidden');
                }
            }
        });
        
        // Currency formatting function for search results
        function formatCurrencyPrice(amount) {
            const currency = '{{ $currentCurrency ?? "GHS" }}';
            const symbols = {
                'USD': '$',
                'GHS': 'GHS ',
                'NGN': '₦'
            };
            // Default to GHS if currency not recognized (not dollar)
            const symbol = symbols[currency] || symbols['GHS'];
            
            // Use actual exchange rates from backend (passed as data attribute or use fallback rates)
            // Exchange rates are cached and updated every 2 minutes on backend
            // For JavaScript, we'll use the rates passed from PHP or make an API call
            // For now, use approximate rates that match CurrencyService fallback
            let convertedAmount = amount;
            if (currency === 'USD') {
                // Convert from GHS to USD (using approximate rate - matches CurrencyService fallback)
                convertedAmount = amount * 0.091;
            } else if (currency === 'NGN') {
                // Convert from GHS to NGN (using approximate rate - matches CurrencyService fallback)
                convertedAmount = amount * 137;
            } else {
                // GHS or unknown - no conversion needed (amount is already in GHS)
                convertedAmount = amount;
            }
            
            return symbol + Math.round(convertedAmount).toLocaleString();
        }

        // Auto-hide success message after 5 seconds
        document.addEventListener('DOMContentLoaded', function() {
            const successMessage = document.getElementById('success-message');
            if (successMessage) {
                setTimeout(function() {
                    successMessage.style.transition = 'opacity 0.5s ease-out';
                    successMessage.style.opacity = '0';
                    setTimeout(function() {
                        successMessage.style.display = 'none';
                    }, 500);
                }, 5000);
            }
        });

        // Analytics Click Tracking - Track all clicks on links and buttons
        document.addEventListener('click', function(e) {
            const target = e.target.closest('a, button, [onclick], [data-url]');
            if (!target) return;
            
            // Skip admin routes
            if (window.location.pathname.startsWith('/admin')) return;
            
            const elementType = target.tagName.toLowerCase();
            const elementId = target.id || null;
            const elementClass = target.className || null;
            const elementText = target.textContent?.trim().substring(0, 100) || null;
            const url = target.href || target.getAttribute('data-url') || null;
            const pageUrl = window.location.pathname;

            // Send click data to server (async, don't wait for response)
            fetch('{{ route("analytics.trackClick") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify({
                    element_type: elementType,
                    element_id: elementId,
                    element_class: elementClass,
                    element_text: elementText,
                    url: url,
                    page_url: pageUrl
                })
            }).catch(error => {
                // Silently fail - don't interrupt user experience
                console.error('Click tracking error:', error);
            });
        });
        // Update Location Function
        function updateLocation(location) {
            const locationText = document.getElementById('location-selector-text');
            if (locationText) {
                locationText.innerHTML = `${location} <svg class="w-3 h-3" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/></svg>`;
            }
            
            // Close dropdown
            const dropdowns = document.querySelectorAll('.group .absolute.top-full');
            dropdowns.forEach(dropdown => {
                dropdown.classList.remove('opacity-100', 'visible');
                dropdown.classList.add('opacity-0', 'invisible');
            });

            // Optional: You could save this to session via AJAX here
            // fetch('/update-location', {
            //     method: 'POST',
            //     headers: {
            //         'Content-Type': 'application/json',
            //         'X-CSRF-TOKEN': '{{ csrf_token() }}'
            //     },
            //     body: JSON.stringify({ location: location })
            // });
        }
    </script>
    @stack('scripts')
    
    <!-- Newsletter Script -->
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const newsletterForm = document.getElementById('newsletter-form');
        const newsletterEmail = document.getElementById('newsletter-email');
        const newsletterError = document.getElementById('newsletter-error');
        const newsletterSuccess = document.getElementById('newsletter-success');
        const newsletterSubmit = document.getElementById('newsletter-submit');
        const newsletterSubmitText = document.getElementById('newsletter-submit-text');
        const newsletterSubmitIcon = document.getElementById('newsletter-submit-icon');
        const newsletterLoadingIcon = document.getElementById('newsletter-loading-icon');
        
        if (newsletterForm) {
            newsletterForm.addEventListener('submit', function(e) {
                e.preventDefault();
                
                // Reset states
                newsletterError.classList.add('hidden');
                newsletterSuccess.classList.add('hidden');
                newsletterEmail.classList.remove('border-red-500');
                
                // Show loading state
                newsletterSubmit.disabled = true;
                newsletterSubmitText.classList.add('hidden');
                newsletterLoadingIcon.classList.remove('hidden');
                
                // Get form data
                const formData = new FormData(newsletterForm);
                
                // Submit via AJAX
                fetch(newsletterForm.action, {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-Requested-With': 'XMLHttpRequest',
                        'Accept': 'application/json',
                    }
                })
                .then(response => response.json())
                .then(data => {
                    // Reset loading state
                    newsletterSubmit.disabled = false;
                    newsletterSubmitText.classList.remove('hidden');
                    newsletterLoadingIcon.classList.add('hidden');
                    
                    if (data.success) {
                        // Show success message
                        newsletterSuccess.querySelector('p').textContent = data.message;
                        newsletterSuccess.classList.remove('hidden');
                        newsletterEmail.value = '';
                        
                        // Show check icon briefly
                        newsletterSubmitIcon.classList.remove('hidden');
                        setTimeout(() => {
                            newsletterSubmitIcon.classList.add('hidden');
                        }, 2000);
                        
                        // Hide success message after 5 seconds
                        setTimeout(() => {
                            newsletterSuccess.classList.add('hidden');
                        }, 5000);
                    } else {
                        // Show error message
                        newsletterError.textContent = data.message || 'Something went wrong. Please try again.';
                        newsletterError.classList.remove('hidden');
                        newsletterEmail.classList.add('border-red-500');
                    }
                })
                .catch(error => {
                    // Reset loading state
                    newsletterSubmit.disabled = false;
                    newsletterSubmitText.classList.remove('hidden');
                    newsletterLoadingIcon.classList.add('hidden');
                    
                    // Show error message
                    newsletterError.textContent = 'Something went wrong. Please try again.';
                    newsletterError.classList.remove('hidden');
                    newsletterEmail.classList.add('border-red-500');
                    
                    console.error('Newsletter subscription error:', error);
                });
            });
        }
    });
    </script>
</body>
</html>

