@extends('layouts.app')

@section('title', 'Home')

@section('content')
<style>
    /* Green outline text effect - exact match */
    .text-outline-green {
        color: #000;
        -webkit-text-stroke: 2px #00ff00;
        text-stroke: 2px #00ff00;
        font-weight: 900;
        letter-spacing: 1px;
    }
    
    /* Category text styling */
    .category-text {
        font-size: 4rem;
        font-weight: 900;
        letter-spacing: 2px;
        line-height: 1.1;
    }
    
    .category-text.highlight {
        color: #33B8A6;
    }
    
    .categories-label {
        font-size: 6rem;
        font-weight: 300;
        color: #d1d5db;
        -webkit-text-stroke: 1px #d1d5db;
        text-stroke: 1px #d1d5db;
        opacity: 0.5;
        letter-spacing: 4px;
    }
    
    /* Product carousel */
    .product-carousel {
        scroll-behavior: smooth;
        scrollbar-width: none;
        -ms-overflow-style: none;
    }
    .product-carousel::-webkit-scrollbar {
        display: none;
    }
    
    /* Product image hover slide */
    .product-image-container {
        position: relative;
    }
    .product-images-wrapper {
        position: relative;
        width: 100%;
        height: 100%;
        display: flex;
        transition: transform 0.5s ease-in-out;
    }
    .product-image {
        min-width: 100%;
        height: 100%;
        object-fit: cover;
        display: block;
    }
    .product-image-container:hover .product-images-wrapper {
        animation: slideImages 3s infinite;
    }
    @keyframes slideImages {
        0%, 20% {
            transform: translateX(0);
        }
        25%, 45% {
            transform: translateX(-100%);
        }
        50%, 70% {
            transform: translateX(-200%);
        }
        75%, 95% {
            transform: translateX(-300%);
        }
        100% {
            transform: translateX(0);
        }
    }
    .product-image-container[data-image-count="1"]:hover .product-images-wrapper {
        animation: none;
    }
    .product-image-container[data-image-count="2"]:hover .product-images-wrapper {
        animation: slideImages2 3s infinite;
    }
    @keyframes slideImages2 {
        0%, 45% {
            transform: translateX(0);
        }
        50%, 95% {
            transform: translateX(-100%);
        }
        100% {
            transform: translateX(0);
        }
    }
    .product-image-container[data-image-count="3"]:hover .product-images-wrapper {
        animation: slideImages3 4s infinite;
    }
    @keyframes slideImages3 {
        0%, 30% {
            transform: translateX(0);
        }
        33%, 63% {
            transform: translateX(-100%);
        }
        66%, 96% {
            transform: translateX(-200%);
        }
        100% {
            transform: translateX(0);
        }
    }
    
    /* Section headers */
    .section-header {
        font-size: 2rem;
        font-weight: 900;
        letter-spacing: 2px;
    }
    @media (min-width: 640px) {
        .section-header {
            font-size: 2.5rem;
        }
    }
    @media (min-width: 768px) {
        .section-header {
            font-size: 3rem;
        }
    }
    @media (min-width: 1024px) {
        .section-header {
            font-size: 3.5rem;
        letter-spacing: 3px;
        }
    }
    
    /* Dark hero section background - concrete texture */
    .hero-dark-bg {
        background: #1a1f1a;
        background-image: 
            radial-gradient(circle at 20% 50%, rgba(0, 255, 0, 0.03) 0%, transparent 50%),
            radial-gradient(circle at 80% 80%, rgba(0, 255, 0, 0.03) 0%, transparent 50%),
            repeating-linear-gradient(0deg, transparent, transparent 1px, rgba(0, 0, 0, 0.15) 1px, rgba(0, 0, 0, 0.15) 2px),
            repeating-linear-gradient(90deg, transparent, transparent 1px, rgba(0, 0, 0, 0.15) 1px, rgba(0, 0, 0, 0.15) 2px);
        position: relative;
    }
    
    /* Instead of neon, define primary color class for hero */
    .hero-primary {
        color: {{ $primaryColor ?? '#ff5349' }};
    }
    /* Remove any text-shadow/glow from headings */
    
    /* Social media sidebar */
    .social-sidebar {
        writing-mode: vertical-rl;
        text-orientation: mixed;
    }
    
    /* Logo outline effect - using primary color */
    .logo-outline {
        color: {{ $primaryColor ?? '#ff5349' }};
    }
    
    /* Spinning circular text animation */
    @keyframes spin-text {
        from {
            transform: rotate(0deg);
        }
        to {
            transform: rotate(360deg);
        }
    }
    
    .spinning-badge {
        animation: spin-text 20s linear infinite;
    }
    
    /* Hero slider styles */
    .hero-slide {
        opacity: 0;
        transition: opacity 0.8s ease-in-out;
        position: absolute;
        width: 100%;
        height: 100%;
        top: 0;
        left: 0;
    }
    
    .hero-slide.active {
        opacity: 1;
        position: absolute;
    }
    
    /* Mobile: Fixed height for slider container */
    @media (max-width: 767px) {
        .hero-slider-container {
            height: 90vh;
            position: relative;
        }
    }
    
    .hero-content-left {
        transition: opacity 0.8s ease-in-out, transform 0.8s ease-in-out;
    }
    
    .hero-image-right {
        transition: opacity 0.8s ease-in-out, transform 0.8s ease-in-out;
    }
    
    /* Black background sliding animation */
    .hero-title-bg {
        position: relative;
        overflow: hidden;
        display: inline-block;
    }
    
    .hero-title-bg::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background-color: {{ $primaryColor ?? '#ff5349' }};
        transition: left 0.8s ease-in-out;
        z-index: -1;
    }
    
    /* Reset animation when slide becomes active */
    .hero-slide:not(.active) .hero-title-bg::before {
        left: -100%;
        transition: none;
    }
    
    .hero-slide.active .hero-title-bg::before {
        left: 0;
        transition: left 0.8s ease-in-out;
    }
    
    .hero-title-text {
        position: relative;
        z-index: 1;
        padding: 0.5rem 1rem;
    }
</style>

<!-- Dark Hero Banner Section - 3 Slide Slider -->
<section class="hero-slider-container min-h-[90vh] md:h-[90vh] flex relative hero-dark-bg overflow-hidden">
    @if($sliders->count() > 0)
        @foreach($sliders as $index => $slider)
        <div class="hero-slide {{ $index === 0 ? 'active' : '' }}" data-slide="{{ $index }}">
            <div class="h-full flex flex-col md:flex-row relative">
                <!-- Left: Promotional Content -->
                <div class="w-full md:w-1/2 flex items-center px-4 sm:px-8 md:pl-20 md:pr-12 py-12 md:py-0 relative z-10 hero-content-left h-[50vh] md:h-full md:min-h-0 overflow-y-auto" style="background-image: url('{{ productImageUrl($slider->image) }}'); background-size: cover; background-position: center;">
                    <div class="absolute inset-0 bg-black bg-opacity-95 z-0"></div>
                    <div class="space-y-4 md:space-y-6 relative z-10 w-full">
                        <div>
                            @if($slider->price && $slider->price > 0)
                                <p class="hero-primary text-lg sm:text-xl md:text-2xl font-bold mb-2">FROM {{ currency($slider->price) }}</p>
                            @endif
                            <h1 class="hero-title-bg text-white text-3xl sm:text-4xl md:text-5xl lg:text-7xl font-black mb-3 leading-tight inline-block">
                                <span class="hero-title-text">{{ $slider->title }}</span>
                            </h1>
                            <p class="text-white text-base sm:text-lg font-bold mb-4 md:mb-6">{{ $slider->subtitle }}</p>
                        </div>
                        
                        <p class="text-white text-sm sm:text-base leading-relaxed max-w-md">
                            {!! $slider->description !!}
                        </p>
                        
                        <a href="{{ $slider->link ? (substr($slider->link, 0, 4) === 'http' ? $slider->link : url($slider->link)) : route('products.index') }}" 
                           class="inline-block border border-white bg-black text-white px-6 sm:px-8 py-2 sm:py-3 text-xs sm:text-sm font-semibold hover:bg-gray-900 transition duration-300 mt-4 md:mt-6">
                            DISCOVER NOW →
                        </a>
                    </div>
                </div>
                
                <!-- Right: Lifestyle Image -->
                <div class="w-full md:w-1/2 relative overflow-hidden hero-image-right h-[40vh] md:h-full md:min-h-0">
                    <img src="{{ productImageUrl($slider->image) }}" 
                         alt="{{ $slider->title }}" 
                         class="w-full h-full object-cover"
                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                    
                    <!-- Large "VIBRANT" text at borders of right image -->
                    <div class="absolute bottom-0 left-0 right-0 z-10 pointer-events-none">
                        <p class="text-white text-[40px] sm:text-[50px] md:text-[60px] lg:text-[80px] xl:text-[120px] font-black leading-none opacity-30 text-center" style="line-height: 1; padding-bottom: 0;">VIBRANT</p>
                    </div>
                    
                    <!-- Circular badge overlay - Perfect SVG with spinning circular text -->
                    <div class="absolute top-4 right-4 md:top-6 md:right-6 w-16 h-16 md:w-28 md:h-28 z-20">
                        <svg viewBox="0 0 100 100" width="100%" height="100%" class="spinning-badge">
                            <circle cx="50" cy="50" r="45" fill="{{ $primaryColor ?? '#ff5349' }}" stroke="black" stroke-width="3"/>
                            <defs>
                                <path id="badge-circle-{{ $index }}" d="M 50,50 m -35,0 a 35,35 0 1,1 70,0 a 35,35 0 1,1 -70,0"/>
                            </defs>
                            <text fill="black" font-size="6.5" font-weight="900" font-family="Arial, sans-serif" letter-spacing="0.5">
                                <textPath href="#badge-circle-{{ $index }}" startOffset="0%">
                                    VIBRANT VOGUE FASHION ON. • VIBRANT VOGUE FASHION ON. • 
                                </textPath>
                            </text>
                        </svg>
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    @else
        <!-- Fallback if no sliders exist -->
        <div class="h-full flex items-center justify-center">
            <p class="text-white text-xl">No sliders available. Please create sliders in the admin panel.</p>
        </div>
    @endif
    
    <!-- Social Media Sidebar (Right Edge) - EXACT POSITION -->
    <div class="hidden md:flex absolute right-4 top-1/2 transform -translate-y-1/2 flex-col gap-6 z-20">
        @if(!empty($whatsappUrl))
            <a href="{{ $whatsappUrl }}" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">WHATSAPP</a>
        @endif
        @if(!empty($facebookUrl))
            <a href="{{ $facebookUrl }}" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">FACEBOOK</a>
        @endif
        @if(!empty($instagramUrl))
            <a href="{{ $instagramUrl }}" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">INSTAGRAM</a>
        @endif
        @if(!empty($youtubeUrl))
            <a href="{{ $youtubeUrl }}" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">YOUTUBE</a>
        @endif
        @if(!empty($tiktokUrl))
            <a href="{{ $tiktokUrl }}" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">TIKTOK</a>
        @endif
        @if(!empty($snapchatUrl))
            <a href="{{ $snapchatUrl }}" target="_blank" rel="noopener noreferrer" class="social-sidebar text-white text-xs font-bold hover:text-primary transition">SNAPCHAT</a>
        @endif
    </div>
    
    <!-- Navigation Arrows (Bottom Right) - In White Box -->
    <div class="absolute bottom-4 right-4 sm:bottom-6 sm:right-6 border border-white bg-transparent p-1 flex gap-1 z-30">
        <button onclick="changeHeroSlide(-1)" class="w-9 h-9 bg-transparent text-white flex items-center justify-center hover:bg-white hover:text-black transition">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </button>
        <button onclick="changeHeroSlide(1)" class="w-9 h-9 bg-transparent text-white flex items-center justify-center hover:bg-white hover:text-black transition">
            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
            </svg>
        </button>
    </div>
</section>

<!-- Top Categories Section - 12 Grid Layout (Jumia Style - 6 Columns) -->
@if(isset($topCategories) && $topCategories->count() > 0)
<section class="bg-white shadow-sm rounded-lg mx-2 md:mx-4 my-4 p-2 md:p-4">
    <div class="grid grid-cols-3 sm:grid-cols-4 md:grid-cols-6 gap-2 md:gap-4">
        <!-- Slot 1-5: Categories -->
        @foreach($topCategories->take(5) as $category)
            <a href="{{ route('products.index', ['category' => $category->id]) }}" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                <div class="w-full aspect-square relative">
                    @if($category->image)
                        <img src="{{ productImageUrl($category->image) }}" alt="{{ $category->name }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                    @else
                         <div class="w-full h-full flex items-center justify-center bg-gray-100 text-gray-300">
                            <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                            </svg>
                         </div>
                    @endif
                    <!-- Text Overlay -->
                    <div class="absolute inset-x-0 bottom-0 bg-black bg-opacity-60 py-1.5 px-1 backdrop-blur-[2px]">
                        <span class="block text-white text-xs md:text-sm font-bold text-center truncate w-full">{{ $category->name }}</span>
                    </div>
                </div>
            </a>
        @endforeach

        <!-- Slot 6: Sell on Trendz (Custom) -->
        <a href="{{ route('store.register') }}" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
            <div class="w-full aspect-square bg-orange-600 relative flex items-center justify-center">
                 <div class="absolute inset-0 bg-gradient-to-br from-orange-500 to-red-600"></div>
                 <div class="relative z-10 text-center p-1">
                    <span class="block text-white font-black text-xl md:text-2xl leading-none drop-shadow-md">SELL</span>
                    <span class="block text-white font-bold text-[10px] md:text-xs uppercase tracking-widest my-1">ON</span>
                    <span class="block text-white font-black text-lg md:text-xl leading-none drop-shadow-md">TRENDZ</span>
                 </div>
            </div>
        </a>

        <!-- Slot 7-11: Categories (Offset 5) -->
        @foreach($topCategories->skip(5)->take(5) as $category)
            <a href="{{ route('products.index', ['category' => $category->id]) }}" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
                <div class="w-full aspect-square relative">
                    @if($category->image)
                        <img src="{{ productImageUrl($category->image) }}" alt="{{ $category->name }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                    @else
                         <div class="w-full h-full flex items-center justify-center bg-gray-100 text-gray-300">
                            <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                            </svg>
                         </div>
                    @endif
                    <!-- Text Overlay -->
                    <div class="absolute inset-x-0 bottom-0 bg-black bg-opacity-60 py-1.5 px-1 backdrop-blur-[2px]">
                        <span class="block text-white text-xs md:text-sm font-bold text-center truncate w-full">{{ $category->name }}</span>
                    </div>
                </div>
            </a>
        @endforeach

        <!-- Slot 12: Big Discount (Custom) -->
        <a href="{{ route('products.index', ['discount' => 'true']) }}" class="flex flex-col items-center group cursor-pointer h-full relative rounded-lg overflow-hidden hover:shadow-lg transition-shadow">
            <div class="w-full aspect-square bg-yellow-400 relative flex items-center justify-center">
                 <div class="absolute inset-0 bg-gradient-to-br from-yellow-400 to-orange-500"></div>
                 <div class="relative z-10 text-center transform group-hover:scale-110 transition-transform duration-300">
                    <span class="block text-white font-black text-2xl md:text-3xl leading-none drop-shadow-md text-shadow-sm">BIG</span>
                    <span class="block text-white font-black text-2xl md:text-3xl leading-none drop-shadow-md text-shadow-sm">SALE</span>
                 </div>
            </div>
        </a>
    </div>
</section>
@endif

<!-- Shop Trending Section: Jumia Style -->
@if($trendingProducts->count() > 0)
<section class="bg-gray-100 py-4 mb-4">
    <div class="container mx-auto px-2 md:px-4">
        <div class="bg-white rounded shadow-sm overflow-hidden">
            <!-- Header -->
            <div class="px-4 py-3 flex justify-between items-center" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                <h3 class="text-white font-bold text-lg md:text-xl uppercase">Trending Now</h3>
                <a href="{{ route('home') }}" class="text-white text-sm font-medium hover:underline flex items-center gap-1">
                Home
                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg"><path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path></svg>
            </a>
            </div>
            
            <!-- Products Grid -->
            <div class="p-2 md:p-4">
                 <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-2 md:gap-4">
                    @foreach($trendingProducts->take(6) as $product)
                        <div class="group relative bg-white hover:shadow-lg transition-shadow duration-300 rounded-md p-2 border border-transparent hover:border-gray-200">
                            <a href="{{ route('products.show', $product->slug) }}" class="block h-full pb-10">
                                <!-- Image -->
                                <div class="relative aspect-[3/4] mb-2 overflow-hidden rounded bg-gray-100">
                                    <img src="{{ productImageUrl($product->image) }}" alt="{{ $product->name }}" class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                                    @if($product->compare_price)
                                        <span class="absolute top-1 right-1 bg-red-100 text-red-600 text-[10px] font-bold px-1.5 py-0.5 rounded">
                                            -{{ round((($product->compare_price - $product->price) / $product->compare_price) * 100) }}%
                                        </span>
                                    @endif
                                </div>
                                
                                <!-- Details -->
                                <div class="space-y-1">
                                    <h4 class="text-xs md:text-sm text-gray-700 line-clamp-2 min-h-[2.5em]" title="{{ $product->name }}">{{ $product->name }}</h4>
                                    <div class="flex flex-col">
                                        <span class="text-sm md:text-base font-bold text-gray-900">{{ currency($product->price) }}</span>
                                        @if($product->compare_price)
                                            <span class="text-xs text-gray-400 line-through">{{ currency($product->compare_price) }}</span>
                                        @endif
                                    </div>
                                </div>
                            </a>
                            
                            <!-- Add to Cart -->
                                    <div class="absolute bottom-2 left-2 right-2 opacity-100 md:opacity-0 md:group-hover:opacity-100 transition-opacity duration-200">
                                         <form action="{{ route('cart.store') }}" method="POST" class="add-to-cart-form" onclick="event.stopPropagation();">
                                            @csrf
                                            <input type="hidden" name="product_id" value="{{ $product->id }}">
                                            <input type="hidden" name="quantity" value="1">
                                            <button type="submit" class="w-full text-white text-xs md:text-sm font-bold py-1.5 rounded hover:bg-opacity-90 transition shadow-sm uppercase tracking-wide" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                                                Add To Cart
                                            </button>
                                        </form>
                                    </div>
                        </div>
                    @endforeach
                 </div>
            </div>
        </div>
    </div>
</section>
@endif

<!-- Shop Top Picks Section: Jumia Style -->
@if(($bannerActiveStatus['featured'] ?? true) || ($showFeaturedProductsSection ?? true))
    @if($showFeaturedProductsSection ?? true && $topPicks->count() > 0)
    <section class="bg-gray-100 py-4 mb-4">
        <div class="container mx-auto px-2 md:px-4">
            <div class="bg-white rounded shadow-sm overflow-hidden">
                <!-- Header -->
                <div class="px-4 py-3 flex justify-between items-center" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                    <h3 class="text-white font-bold text-lg md:text-xl uppercase">Featured Products</h3>
                    <a href="{{ route('products.index', ['featured' => 1]) }}" class="text-white text-sm font-medium hover:underline flex items-center gap-1">
                        See All 
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                    </a>
                </div>
                
                <!-- Products Grid -->
                <div class="p-2 md:p-4">
                     <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-2 md:gap-4">
                        @foreach($topPicks->take(6) as $product)
                            <div class="group relative bg-white hover:shadow-lg transition-shadow duration-300 rounded-md p-2 border border-transparent hover:border-gray-200">
                                <a href="{{ route('products.show', $product->slug) }}" class="block h-full pb-10">
                                    <!-- Image -->
                                    <div class="relative aspect-[3/4] mb-2 overflow-hidden rounded bg-gray-100">
                                        <img src="{{ productImageUrl($product->image) }}" alt="{{ $product->name }}" class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                                        @if($product->compare_price)
                                            <span class="absolute top-1 right-1 bg-red-100 text-red-600 text-[10px] font-bold px-1.5 py-0.5 rounded">
                                                -{{ round((($product->compare_price - $product->price) / $product->compare_price) * 100) }}%
                                            </span>
                                        @endif
                                    </div>
                                    
                                    <!-- Details -->
                                    <div class="space-y-1">
                                        <h4 class="text-xs md:text-sm text-gray-700 line-clamp-2 min-h-[2.5em]" title="{{ $product->name }}">{{ $product->name }}</h4>
                                        <div class="flex flex-col">
                                            <span class="text-sm md:text-base font-bold text-gray-900">{{ currency($product->price) }}</span>
                                            @if($product->compare_price)
                                                <span class="text-xs text-gray-400 line-through">{{ currency($product->compare_price) }}</span>
                                            @endif
                                        </div>
                                    </div>
                                </a>
                                
                                <!-- Add to Cart -->
                                <div class="absolute bottom-2 left-2 right-2 opacity-100 md:opacity-0 md:group-hover:opacity-100 transition-opacity duration-200">
                                     <form action="{{ route('cart.store') }}" method="POST" class="add-to-cart-form" onclick="event.stopPropagation();">
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="w-full text-white text-xs md:text-sm font-bold py-1.5 rounded hover:bg-opacity-90 transition shadow-sm uppercase tracking-wide" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                                            Add To Cart
                                        </button>
                                    </form>
                                </div>
                            </div>
                        @endforeach
                     </div>
                </div>
            </div>
        </div>
    </section>
    @endif
@endif

<!-- Clearance Sale Marquee Banner -->
<section class="bg-black py-4 overflow-hidden">
    <div class="marquee-container">
        <div class="marquee-content">
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
        </div>
        <div class="marquee-content" aria-hidden="true">
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
            <span class="text-white" style="text-shadow: 0 0 10px rgba(255,255,255,0.5), 0 0 20px rgba(255,255,255,0.3);">WEAR VOGUE</span>
            <span class="font-bold" style="color: {{ $primaryColor ?? '#ff5349' }};">. LOOK VIBRANT .</span>
        </div>
    </div>
    <style>
        .marquee-container {
            display: flex;
            overflow: hidden;
            white-space: nowrap;
        }
        .marquee-content {
            display: inline-flex;
            align-items: center;
            gap: 3rem;
            animation: marquee 30s linear infinite;
            font-size: 2rem;
            font-weight: 900;
            text-transform: uppercase;
            letter-spacing: 0.1em;
        }
        .marquee-content span {
            flex-shrink: 0;
        }
        @keyframes marquee {
            0% {
                transform: translateX(0);
            }
            100% {
                transform: translateX(-50%);
            }
        }
    </style>
</section>

<!-- Shop For Her / Shop For Him Split Section -->
@if(($bannerActiveStatus['shop_for_her'] ?? true) || ($bannerActiveStatus['shop_for_him'] ?? true))
<section class="flex flex-col md:flex-row min-h-[500px] md:min-h-[600px]">
    <!-- Left: Shop For Her -->
    @if($bannerActiveStatus['shop_for_her'] ?? true)
    <div class="w-full md:w-1/2 relative min-h-[300px] md:min-h-0 group" style="overflow: visible;">
        <!-- Background Image -->
        <div class="absolute inset-0 bg-gradient-to-br from-pink-900 via-purple-900 to-pink-800" style="overflow: visible;">
            <img src="{{ productImageUrl($bannerSettings['shop_for_her']['banner_image']) }}" 
             alt="Shop For Her" 
                 class="absolute top-0 left-0 w-full h-[300px] md:inset-0 md:h-full object-contain md:object-cover opacity-60 group-hover:opacity-70 transition-opacity duration-500"
                 style="object-position: center; max-width: 100%; max-height: 300px;"
                 onerror="this.src='https://images.unsplash.com/photo-1490481651871-ab68de25d43d?w=1200&h=1600&fit=crop'; this.onerror=null;">
                </div>
        
        <!-- Gradient Overlay -->
        <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/50 to-transparent"></div>
        
        <!-- Content -->
        <div class="absolute bottom-0 left-0 right-0 p-6 sm:p-8 md:p-12 text-white">
            <div class="space-y-4">
                <!-- Badge -->
                @if($bannerSettings['shop_for_her']['banner_subtitle'])
                <div class="inline-block">
                    <span class="bg-white/20 backdrop-blur-sm text-white px-4 py-2 rounded-full text-xs sm:text-sm font-bold uppercase tracking-wider">
                        {{ $bannerSettings['shop_for_her']['banner_subtitle'] }}
                    </span>
                </div>
                @endif
                
                <!-- Title -->
                @if($bannerSettings['shop_for_her']['banner_title'])
                <div class="space-y-2">
                    <h3 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-black leading-tight">
                        {!! str_replace(' ', '<br>', $bannerSettings['shop_for_her']['banner_title']) !!}
                    </h3>
                </div>
                @endif
                
                <!-- Description -->
                @if($bannerSettings['shop_for_her']['banner_description'])
                <p class="text-white/90 text-sm sm:text-base max-w-md leading-relaxed">
                    {{ $bannerSettings['shop_for_her']['banner_description'] }}
                </p>
                @endif
                
                <!-- CTA Button -->
                <a href="{{ $bannerSettings['shop_for_her']['banner_link'] ?? route('products.index', ['category' => $categories->where('name', 'like', '%women%')->first()->id ?? '']) }}" 
                   class="inline-flex items-center gap-3 bg-white text-gray-900 px-6 sm:px-8 py-3 sm:py-4 rounded-lg font-bold text-sm sm:text-base hover:bg-gray-100 transition shadow-xl hover:shadow-2xl transform hover:-translate-y-1 mt-6">
                    <span>DISCOVER NOW</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
            </div>
        </div>
    </div>
    @endif
    
    <!-- Right: Shop For Him -->
    @if($bannerActiveStatus['shop_for_him'] ?? true)
    <div class="w-full {{ ($bannerActiveStatus['shop_for_her'] ?? true) ? 'md:w-1/2' : 'md:w-full' }} relative min-h-[300px] md:min-h-0 group" style="overflow: visible;">
        <!-- Background Image -->
        <div class="absolute inset-0 bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900" style="overflow: visible;">
            <img src="{{ productImageUrl($bannerSettings['shop_for_him']['banner_image']) }}" 
             alt="Shop For Him" 
                 class="absolute top-0 left-0 w-full h-[300px] md:inset-0 md:h-full object-contain md:object-cover opacity-60 group-hover:opacity-70 transition-opacity duration-500"
                 style="object-position: center; max-width: 100%; max-height: 300px;"
                 onerror="this.src='https://images.unsplash.com/photo-1617137968427-85924c800a22?w=1200&h=1600&fit=crop'; this.onerror=null;">
        </div>
        
        <!-- Gradient Overlay -->
        <div class="absolute inset-0 bg-gradient-to-t from-black/80 via-black/50 to-transparent"></div>
        
        <!-- Content -->
        <div class="absolute bottom-0 left-0 right-0 p-6 sm:p-8 md:p-12 text-white">
            <div class="space-y-4">
                <!-- Badge -->
                @if($bannerSettings['shop_for_him']['banner_subtitle'])
                <div class="inline-block">
                    <span class="bg-white/20 backdrop-blur-sm text-white px-4 py-2 rounded-full text-xs sm:text-sm font-bold uppercase tracking-wider">
                        {{ $bannerSettings['shop_for_him']['banner_subtitle'] }}
                    </span>
                </div>
                @endif
                
                <!-- Title -->
                @if($bannerSettings['shop_for_him']['banner_title'])
            <div class="space-y-2">
                    <h3 class="text-4xl sm:text-5xl md:text-6xl lg:text-7xl font-black leading-tight">
                        {!! str_replace(' ', '<br>', $bannerSettings['shop_for_him']['banner_title']) !!}
                    </h3>
                </div>
                @endif
                
                <!-- Description -->
                @if($bannerSettings['shop_for_him']['banner_description'])
                <p class="text-white/90 text-sm sm:text-base max-w-md leading-relaxed">
                    {{ $bannerSettings['shop_for_him']['banner_description'] }}
                </p>
                @endif
                
                <!-- CTA Button -->
                <a href="{{ $bannerSettings['shop_for_him']['banner_link'] ?? route('products.index', ['category' => $categories->where('name', 'like', '%men%')->first()->id ?? '']) }}" 
                   class="inline-flex items-center gap-3 bg-white text-gray-900 px-6 sm:px-8 py-3 sm:py-4 rounded-lg font-bold text-sm sm:text-base hover:bg-gray-100 transition shadow-xl hover:shadow-2xl transform hover:-translate-y-1 mt-6">
                    <span>DISCOVER NOW</span>
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                    </svg>
                </a>
                </div>
        </div>
    </div>
    @endif
</section>
@endif

<script>
let currentHeroSlide = 0;
const totalHeroSlides = {{ $sliders->count() ?? 0 }};
let heroSlideInterval;

function changeHeroSlide(direction) {
    const slides = document.querySelectorAll('.hero-slide');
    
    // Remove active class from current slide (this resets the animation)
    slides[currentHeroSlide].classList.remove('active');
    
    // Calculate new slide index
    if (direction === undefined) {
        // Auto-advance
        currentHeroSlide = (currentHeroSlide + 1) % totalHeroSlides;
    } else {
        // Manual navigation
        currentHeroSlide += direction;
        
        // Loop around
        if (currentHeroSlide < 0) {
            currentHeroSlide = totalHeroSlides - 1;
        } else if (currentHeroSlide >= totalHeroSlides) {
            currentHeroSlide = 0;
        }
    }
    
    // Small delay to ensure animation resets, then add active class (this triggers the slide-in animation)
    setTimeout(() => {
        slides[currentHeroSlide].classList.add('active');
    }, 50);
    
    // Reset auto-play timer
    clearInterval(heroSlideInterval);
    startAutoPlay();
}

function startAutoPlay() {
    heroSlideInterval = setInterval(() => {
        changeHeroSlide();
    }, 5000); // Change slide every 5 seconds
}

// Start auto-play when page loads
document.addEventListener('DOMContentLoaded', function() {
    startAutoPlay();
});

function scrollCarousel(carouselId, direction) {
    const carousel = document.getElementById(carouselId + '-carousel');
    if (!carousel) return;
    
    // Calculate scroll amount based on carousel type
    let scrollAmount = 300; // Default
    if (carouselId === 'featured') {
        scrollAmount = 340; // Width of featured product card + gap
    }
    
    carousel.scrollBy({
        left: direction * scrollAmount,
        behavior: 'smooth'
    });
}

// Wishlist functionality
function addToWishlist(form, productId) {
    const formData = new FormData(form);
    const url = form.action;
    const method = form.querySelector('input[name="_method"]')?.value || 'POST';
    
    fetch(url, {
        method: method,
        body: formData,
        headers: {
            'X-Requested-With': 'XMLHttpRequest',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update button state
            const button = form.querySelector('button');
            const svg = button.querySelector('svg');
            if (data.added) {
                button.classList.add('text-primary');
                svg.setAttribute('fill', 'currentColor');
                // Update form action for removal
                form.action = '/wishlist/' + productId;
                if (!form.querySelector('input[name="_method"]')) {
                    const methodInput = document.createElement('input');
                    methodInput.type = 'hidden';
                    methodInput.name = '_method';
                    methodInput.value = 'DELETE';
                    form.appendChild(methodInput);
                } else {
                    form.querySelector('input[name="_method"]').value = 'DELETE';
                }
            } else {
                button.classList.remove('text-primary');
                svg.setAttribute('fill', 'none');
                // Update form action for addition
                form.action = '/wishlist/' + productId;
                const methodInput = form.querySelector('input[name="_method"]');
                if (methodInput) {
                    methodInput.remove();
                }
            }
        }
    })
    .catch(error => {
        console.error('Wishlist error:', error);
    });
}

</script>
<!-- Top 8 Popular Product Categories -->
@if(isset($topCategorySections) && $topCategorySections->count())
    @foreach($topCategorySections as $section)
        @if($section->products->count())
        <section class="bg-gray-100 py-4 mb-4">
            <div class="container mx-auto px-2 md:px-4">
                <div class="bg-white rounded shadow-sm overflow-hidden">
                    <!-- Header for each category -->
                    <div class="px-4 py-3 flex justify-between items-center" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                        <h3 class="text-white font-bold text-lg md:text-xl uppercase">{{ $section->category->name }}</h3>
                        <a href="{{ route('products.index', ['category' => $section->category->id]) }}" class="text-white text-sm font-medium hover:underline flex items-center gap-1">
                            See All 
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/></svg>
                        </a>
                    </div>
                    <!-- Products Grid -->
                    <div class="p-2 md:p-4">
                        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-2 md:gap-4">
                            @foreach($section->products as $product)
                            <div class="group relative bg-white hover:shadow-lg transition-shadow duration-300 rounded-md p-2 border border-transparent hover:border-gray-200">
                                <a href="{{ route('products.show', $product->slug) }}" class="block h-full pb-10">
                                    <!-- Image -->
                                    <div class="relative aspect-[3/4] mb-2 overflow-hidden rounded bg-gray-100">
                                        <img src="{{ productImageUrl($product->image) }}" alt="{{ $product->name }}" class="w-full h-full object-cover group-hover:scale-105 transition duration-300">
                                        @if($product->compare_price)
                                            <span class="absolute top-1 right-1 bg-red-100 text-red-600 text-[10px] font-bold px-1.5 py-0.5 rounded">
                                                -{{ round((($product->compare_price - $product->price) / $product->compare_price) * 100) }}%
                                            </span>
                                        @endif
                                    </div>
                                    <!-- Details -->
                                    <div class="space-y-1">
                                        <h4 class="text-xs md:text-sm text-gray-700 line-clamp-2 min-h-[2.5em]" title="{{ $product->name }}">{{ $product->name }}</h4>
                                        <div class="flex flex-col">
                                            <span class="text-sm md:text-base font-bold text-gray-900">{{ currency($product->price) }}</span>
                                            @if($product->compare_price)
                                                <span class="text-xs text-gray-400 line-through">{{ currency($product->compare_price) }}</span>
                                            @endif
                                        </div>
                                    </div>
                                </a>
                                <!-- Add to Cart -->
                                <div class="absolute bottom-2 left-2 right-2 opacity-100 md:opacity-0 md:group-hover:opacity-100 transition-opacity duration-200">
                                    <form action="{{ route('cart.store') }}" method="POST" class="add-to-cart-form" onclick="event.stopPropagation();">
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                                        <input type="hidden" name="quantity" value="1">
                                        <button type="submit" class="w-full text-white text-xs md:text-sm font-bold py-1.5 rounded hover:bg-opacity-90 transition shadow-sm uppercase tracking-wide" style="background-color: {{ $primaryColor ?? '#ff5349' }};">
                                            Add To Cart
                                        </button>
                                    </form>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </section>
        @endif
    @endforeach
@endif

@endsection
