<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Your Password - {{ $siteTitle ?? 'Vibrant Vogue' }}</title>
</head>
<body style="margin: 0; padding: 0; background-color: #fef7ed; font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;">
    <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="background-color: #fef7ed; padding: 60px 20px;">
        <tr>
            <td align="center">
                <table role="presentation" width="600" cellpadding="0" cellspacing="0" style="background-color: #ffffff; border-radius: 16px; overflow: hidden; box-shadow: 0 8px 24px rgba(0,0,0,0.08);">
                    
                    <!-- Logo/Header Area -->
                    <tr>
                        <td style="padding: 40px 40px 20px 40px; text-align: left;">
                            <div style="width: 60px; height: 60px; background-color: {{ $primaryColor ?? '#ff5349' }}; border-radius: 12px; display: inline-block;"></div>
                        </td>
                    </tr>
                    
                    <!-- Main Content -->
                    <tr>
                        <td style="padding: 0 40px 40px 40px;">
                            <!-- Greeting -->
                            <p style="color: #6b7280; font-size: 16px; margin: 0 0 10px 0; font-weight: 400;">Hello, {{ $user->name }}</p>
                            <h1 style="color: {{ $primaryColor ?? '#ff5349' }}; font-size: 36px; font-weight: 700; margin: 0 0 30px 0; letter-spacing: -0.5px; line-height: 1.2;">Reset Your Password</h1>
                            
                            <!-- Decorative Illustration Area -->
                            <div style="background: linear-gradient(135deg, #fff5e6 0%, #ffe8cc 100%); border-radius: 20px; padding: 50px 30px; margin: 40px 0; text-align: center; position: relative; overflow: hidden;">
                                <!-- Simple decorative elements -->
                                <div style="font-size: 80px; line-height: 1; margin-bottom: 20px;">🔑</div>
                                <div style="position: absolute; top: 20px; right: 30px; width: 40px; height: 40px; background-color: {{ $primaryColor ?? '#ff5349' }}20; border-radius: 50%;"></div>
                                <div style="position: absolute; bottom: 30px; left: 40px; width: 30px; height: 30px; background-color: {{ $primaryColor ?? '#ff5349' }}15; border-radius: 50%;"></div>
                            </div>
                            
                            <!-- Instruction Text -->
                            <p style="color: #4a4a4a; font-size: 16px; line-height: 1.8; margin: 0 0 35px 0;">
                                We received a request to reset your password. Please use the verification code below to proceed with resetting your password:
                            </p>
                            
                            <!-- OTP Code Display -->
                            <table role="presentation" width="100%" cellpadding="0" cellspacing="0" style="margin: 40px 0;">
                                <tr>
                                    <td align="center">
                                        <div style="background-color: #f9fafb; border: 3px solid {{ $primaryColor ?? '#ff5349' }}; border-radius: 16px; padding: 40px 30px; max-width: 400px;">
                                            <p style="color: #6b7280; font-size: 11px; margin: 0 0 18px 0; text-transform: uppercase; letter-spacing: 2px; font-weight: 600;">Your Reset Code</p>
                                            <p style="color: {{ $primaryColor ?? '#ff5349' }}; font-size: 48px; font-weight: 800; letter-spacing: 12px; margin: 0; font-family: 'Courier New', 'Monaco', monospace; line-height: 1.2;">{{ $otp }}</p>
                                        </div>
                                    </td>
                                </tr>
                            </table>
                            
                            <!-- Expiration Notice -->
                            <div style="background-color: #fef3c7; border-left: 4px solid #f59e0b; border-radius: 8px; padding: 18px 20px; margin: 30px 0;">
                                <p style="color: #92400e; font-size: 14px; line-height: 1.6; margin: 0;">
                                    ⏰ <strong>Important:</strong> This code will expire in <strong>15 minutes</strong>. Please enter it on the password reset page to continue.
                                </p>
                            </div>
                            
                            <p style="color: #9ca3af; font-size: 14px; line-height: 1.6; margin: 30px 0 0 0; text-align: center;">
                                Didn't request this? You can safely ignore this email. Your password will remain unchanged.
                            </p>
                        </td>
                    </tr>
                    
                    <!-- Footer -->
                    <tr>
                        <td style="padding: 40px; background-color: #f9fafb; border-top: 1px solid #e5e7eb;">
                            <p style="color: #666666; font-size: 14px; line-height: 1.6; margin: 20px 0 0 0;">
                                Best regards,<br>
                                The {{ $siteTitle ?? 'Vibrant Vogue' }} Team
                            </p>
                            <p style="color: #999999; font-size: 12px; margin: 20px 0 0 0; border-top: 1px solid #e5e7eb; padding-top: 20px;">
                                &copy; {{ date('Y') }} {{ $siteTitle ?? 'Vibrant Vogue' }}. All rights reserved.
                            </p>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>

