@extends('layouts.app')

@section('title', 'Shopping Cart')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <h1 class="font-display text-3xl font-bold text-gray-900 mb-8">Shopping Cart</h1>

    @if($cartItems->count() > 0)
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Cart Items -->
            <div class="lg:col-span-2 space-y-4">
                @foreach($cartItems as $item)
                    @if($item->product)
                    <div class="bg-white rounded-lg shadow-md p-6 flex flex-col md:flex-row gap-6">
                        <div class="w-full md:w-32 h-32 bg-gray-200 rounded-lg overflow-hidden flex-shrink-0">
                            <img src="{{ productImageUrl($item->product->image) }}" alt="{{ $item->product->name }}" class="w-full h-full object-cover"
                                 onerror="this.src='{{ asset('images/placeholder.jpg') }}'; this.onerror=null;">
                        </div>
                        <div class="flex-1">
                            <h3 class="font-semibold text-lg text-gray-900 mb-2">
                                <a href="{{ route('products.show', $item->product->slug ?? '#') }}" class="hover:text-primary transition">
                                    {{ $item->product->name ?? 'Product' }}
                                </a>
                            </h3>
                            <p class="text-gray-600 text-sm mb-2">{{ $item->product->category->name ?? 'N/A' }}</p>
                            @if($item->size)
                                <p class="text-gray-600 text-sm">Size: {{ $item->size }}</p>
                            @endif
                            @if($item->color)
                                <p class="text-gray-600 text-sm">Color: {{ $item->color }}</p>
                            @endif
                            <p class="text-primary font-bold text-lg mt-2">{{ currency($item->product->price ?? 0) }}</p>
                        </div>
                        <div class="flex flex-col items-end justify-between">
                            <form action="{{ route('cart.update', $item->id) }}" method="POST" class="mb-4">
                                @csrf
                                @method('PUT')
                                <div class="flex items-center gap-2">
                                    <label class="text-sm text-gray-700">Qty:</label>
                                    <input type="number" name="quantity" value="{{ $item->quantity }}" min="1" max="{{ $item->product->stock ?? 999 }}" class="w-20 border border-gray-300 rounded-md px-2 py-1 text-center focus:outline-none focus:ring-2 focus:ring-primary">
                                    <button type="submit" class="text-primary hover:text-primary-dark transition">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                                        </svg>
                                    </button>
                                </div>
                            </form>
                            <p class="text-gray-900 font-semibold mb-4">{{ currency($item->subtotal) }}</p>
                            <form action="{{ route('cart.destroy', $item->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-red-600 hover:text-red-700 transition">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                    </svg>
                                </button>
                            </form>
                        </div>
                    </div>
                    @endif
                @endforeach
            </div>

            <!-- Order Summary -->
            <div class="lg:col-span-1">
                <div class="bg-white rounded-lg shadow-md p-6 sticky top-20">
                    <h2 class="font-display text-2xl font-bold text-gray-900 mb-6">Order Summary</h2>
                    <div class="space-y-4 mb-6">
                        <div class="flex justify-between text-gray-700">
                            <span>Subtotal</span>
                            <span>{{ currency($total) }}</span>
                        </div>
                        <div class="border-t border-gray-300 pt-4">
                            <div class="flex justify-between text-gray-900 font-bold text-lg">
                                <span>Total</span>
                                <span>{{ currency($total) }}</span>
                            </div>
                        </div>
                    </div>
                    <a href="{{ route('checkout') }}" class="block w-full bg-primary text-white px-6 py-3 rounded-md text-center font-semibold hover:bg-primary-dark transition">
                        Proceed to Checkout
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="text-center py-12 bg-white rounded-lg shadow-md">
            <svg class="w-24 h-24 mx-auto text-gray-400 mb-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"></path>
            </svg>
            <h2 class="font-display text-2xl font-bold text-gray-900 mb-4">Your cart is empty</h2>
            <p class="text-gray-600 mb-6">Start shopping to add items to your cart!</p>
            <a href="{{ route('products.index') }}" class="inline-block bg-primary text-white px-6 py-3 rounded-md font-semibold hover:bg-primary-dark transition">
                Browse Products
            </a>
        </div>
    @endif
</div>
@endsection

