@extends('layouts.app')

@section('title', 'Manage Sliders - Admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-8">
        <h1 class="text-3xl font-bold text-gray-900">Sliders & Banners</h1>
        <p class="text-gray-600 mt-2">Manage your homepage sliders and promotional banners</p>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    <!-- Tabs -->
    <div class="bg-white shadow-lg rounded-xl overflow-hidden">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px" aria-label="Tabs">
                <button onclick="switchTab('sliders')" id="tab-sliders" class="tab-button flex-1 py-4 px-6 text-center border-b-2 font-medium text-sm transition-all">
                    <span class="flex items-center justify-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                        </svg>
                        Hero Sliders
                    </span>
                </button>
                <button onclick="switchTab('banners')" id="tab-banners" class="tab-button flex-1 py-4 px-6 text-center border-b-2 font-medium text-sm transition-all">
                    <span class="flex items-center justify-center gap-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21a4 4 0 01-4-4V5a2 2 0 012-2h4a2 2 0 012 2v12a4 4 0 01-4 4zm0 0h12a2 2 0 002-2v-4a2 2 0 00-2-2h-2.343M11 7.343l1.657-1.657a2 2 0 012.828 0l2.829 2.829a2 2 0 010 2.828l-8.486 8.485M7 17h.01"/>
                        </svg>
                        Banners
                    </span>
                </button>
            </nav>
        </div>

        <!-- Tab Content: Sliders -->
        <div id="content-sliders" class="tab-content p-6">
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h2 class="text-xl font-bold text-gray-900">Hero Slider Management</h2>
                    <p class="text-gray-600 text-sm mt-1">Manage the hero banner sliders on the homepage</p>
                </div>
                <a href="{{ route('admin.sliders.create') }}" class="bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark transition">
                    Create New Slider
                </a>
            </div>

            @if($sliders->count() > 0)
                <div class="bg-white shadow overflow-hidden sm:rounded-md">
                    <ul class="divide-y divide-gray-200">
                        @foreach($sliders as $slider)
                            <li>
                                <div class="px-4 py-4 sm:px-6 flex items-center justify-between">
                                    <div class="flex items-center space-x-4 flex-1">
                                        <div class="flex-shrink-0">
                                    <img src="{{ productImageUrl($slider->image) }}" alt="{{ $slider->title }}" class="h-20 w-20 object-cover rounded"
                                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <div class="flex items-center space-x-2">
                                                <p class="text-lg font-semibold text-gray-900">{{ $slider->title }}</p>
                                                @if($slider->is_active)
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                        Active
                                                    </span>
                                                @else
                                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                        Inactive
                                                    </span>
                                                @endif
                                            </div>
                                            <p class="text-sm text-gray-500 mt-1">{{ $slider->subtitle }}</p>
                                            <p class="text-sm text-gray-500">
                                                Order: {{ $slider->order }}
                                                @if($slider->price && $slider->price > 0)
                                                    | Price: {{ currency($slider->price) }}
                                                @endif
                                            </p>
                                            @if($slider->link)
                                                <p class="text-xs text-gray-400 mt-1">Link: <span class="font-mono">{{ $slider->link }}</span></p>
                                            @else
                                                <p class="text-xs text-gray-400 mt-1">Link: <span class="italic">Default (Products Page)</span></p>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <a href="{{ route('admin.sliders.edit', $slider) }}" class="text-primary hover:text-primary-dark">
                                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                            </svg>
                                        </a>
                                        <form action="{{ route('admin.sliders.destroy', $slider) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this slider?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:text-red-800">
                                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                                </svg>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @else
                <div class="bg-gray-50 rounded-lg p-12 text-center">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                    </svg>
                    <p class="text-gray-500 mt-4">No sliders found. Create your first slider!</p>
                    <a href="{{ route('admin.sliders.create') }}" class="inline-block mt-4 bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark transition">
                        Create New Slider
                    </a>
                </div>
            @endif
        </div>

        <!-- Tab Content: Banners -->
        <div id="content-banners" class="tab-content p-6 hidden">
            <div class="mb-6">
                <h2 class="text-xl font-bold text-gray-900 mb-2">Banner Management</h2>
                <p class="text-gray-600 text-sm">Manage homepage banners and promotional sections</p>
            </div>
            
            <!-- Banner List -->
            <div id="banner-list" class="space-y-4">
                <!-- Featured Products Banner Card -->
                <div onclick="openBannerForm('featured')" class="bg-white border-2 border-gray-200 rounded-xl p-6 cursor-pointer hover:border-primary hover:shadow-lg transition-all">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-4 flex-1">
                            <div class="flex-shrink-0">
                                @if($bannerSettings['featured']['banner_image'])
                                    <img src="{{ productImageUrl($bannerSettings['featured']['banner_image']) }}" 
                                         alt="Featured Banner" 
                                         class="h-20 w-20 object-cover rounded-lg border-2 border-gray-200"
                                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                @else
                                    <div class="h-20 w-20 bg-gray-100 rounded-lg border-2 border-gray-200 flex items-center justify-center">
                                        <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                        </svg>
                                    </div>
                                @endif
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center space-x-2">
                                    <h3 class="text-lg font-semibold text-gray-900">Featured Products Banner</h3>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                        Active
                                    </span>
                                </div>
                                <p class="text-sm text-gray-600 mt-1">Configure the banner displayed in the featured products section on homepage</p>
                                @if($bannerSettings['featured']['banner_title'])
                                    <p class="text-xs text-gray-500 mt-2">Title: <span class="font-medium">{{ $bannerSettings['featured']['banner_title'] }}</span></p>
                                @else
                                    <p class="text-xs text-gray-400 mt-2 italic">No title set</p>
                                @endif
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </div>
                    </div>
                </div>
                
                <!-- Shop For Her Banner Card -->
                <div onclick="openBannerForm('shop_for_her')" class="bg-white border-2 border-gray-200 rounded-xl p-6 cursor-pointer hover:border-primary hover:shadow-lg transition-all">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-4 flex-1">
                            <div class="flex-shrink-0">
                                @if($bannerSettings['shop_for_her']['banner_image'])
                                    <img src="{{ productImageUrl($bannerSettings['shop_for_her']['banner_image']) }}" 
                                         alt="Left Collection Banner" 
                                         class="h-20 w-20 object-cover rounded-lg border-2 border-gray-200"
                                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                @else
                                    <div class="h-20 w-20 bg-gray-100 rounded-lg border-2 border-gray-200 flex items-center justify-center">
                                        <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                        </svg>
                                    </div>
                                @endif
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center space-x-2">
                                    <h3 class="text-lg font-semibold text-gray-900">Left Collection Banner</h3>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                        Active
                                    </span>
                                </div>
                                <p class="text-sm text-gray-600 mt-1">Configure the left banner displayed on the homepage</p>
                                @if($bannerSettings['shop_for_her']['banner_title'])
                                    <p class="text-xs text-gray-500 mt-2">Title: <span class="font-medium">{{ $bannerSettings['shop_for_her']['banner_title'] }}</span></p>
                                @else
                                    <p class="text-xs text-gray-400 mt-2 italic">No title set</p>
                                @endif
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </div>
                    </div>
                </div>
                
                <!-- Shop For Him Banner Card -->
                <div onclick="openBannerForm('shop_for_him')" class="bg-white border-2 border-gray-200 rounded-xl p-6 cursor-pointer hover:border-primary hover:shadow-lg transition-all">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-4 flex-1">
                            <div class="flex-shrink-0">
                                @if($bannerSettings['shop_for_him']['banner_image'])
                                    <img src="{{ productImageUrl($bannerSettings['shop_for_him']['banner_image']) }}" 
                                         alt="Right Collection Banner" 
                                         class="h-20 w-20 object-cover rounded-lg border-2 border-gray-200"
                                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                @else
                                    <div class="h-20 w-20 bg-gray-100 rounded-lg border-2 border-gray-200 flex items-center justify-center">
                                        <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                        </svg>
                                    </div>
                                @endif
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center space-x-2">
                                    <h3 class="text-lg font-semibold text-gray-900">Right Collection Banner</h3>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                        Active
                                    </span>
                                </div>
                                <p class="text-sm text-gray-600 mt-1">Configure the right banner displayed on the homepage</p>
                                @if($bannerSettings['shop_for_him']['banner_title'])
                                    <p class="text-xs text-gray-500 mt-2">Title: <span class="font-medium">{{ $bannerSettings['shop_for_him']['banner_title'] }}</span></p>
                                @else
                                    <p class="text-xs text-gray-400 mt-2 italic">No title set</p>
                                @endif
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </div>
                    </div>
                </div>
                
                <!-- Trending Banner Card -->
                <div onclick="openBannerForm('trending')" class="bg-white border-2 border-gray-200 rounded-xl p-6 cursor-pointer hover:border-primary hover:shadow-lg transition-all">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-4 flex-1">
                            <div class="flex-shrink-0">
                                @if($bannerSettings['trending']['banner_image'])
                                    <img src="{{ productImageUrl($bannerSettings['trending']['banner_image']) }}" 
                                         alt="Trending Banner" 
                                         class="h-20 w-20 object-cover rounded-lg border-2 border-gray-200"
                                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                @else
                                    <div class="h-20 w-20 bg-gray-100 rounded-lg border-2 border-gray-200 flex items-center justify-center">
                                        <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                        </svg>
                                    </div>
                                @endif
                            </div>
                            <div class="flex-1 min-w-0">
                                <div class="flex items-center space-x-2">
                                    <h3 class="text-lg font-semibold text-gray-900">Trending Banner</h3>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                        Active
                                    </span>
                                </div>
                                <p class="text-sm text-gray-600 mt-1">Configure the trending section banner on the homepage</p>
                                @if($bannerSettings['trending']['banner_title'])
                                    <p class="text-xs text-gray-500 mt-2">Title: <span class="font-medium">{{ $bannerSettings['trending']['banner_title'] }}</span></p>
                                @else
                                    <p class="text-xs text-gray-400 mt-2 italic">No title set</p>
                                @endif
                            </div>
                        </div>
                        <div class="flex-shrink-0">
                            <svg class="w-6 h-6 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
                            </svg>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Banner Form (Hidden by default) -->
            <div id="banner-form-container" class="hidden mt-6">
                <div class="bg-white border-2 border-primary rounded-xl overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 id="banner-form-title" class="text-lg font-semibold text-gray-900">Featured Products Banner</h3>
                                <p class="text-sm text-gray-600 mt-1">Configure the banner settings</p>
                            </div>
                            <button onclick="closeBannerForm()" class="text-gray-400 hover:text-gray-600 transition">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                                </svg>
                            </button>
                        </div>
                    </div>
                
                    <form action="{{ route('admin.sliders.banner-settings') }}" method="POST" enctype="multipart/form-data" class="p-6">
                        @csrf
                        @method('POST')
                        <input type="hidden" name="banner_type" id="banner_type" value="featured">
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Banner Image -->
                            <div class="md:col-span-2">
                                <label for="banner_image" class="block text-sm font-semibold text-gray-700 mb-2">
                                    Banner Image
                                </label>
                                <div id="current-banner-image-container" class="mb-4 hidden">
                                    <p class="text-sm text-gray-600 mb-2">Current Banner Image:</p>
                                    <img id="current-banner-image" src="" alt="Current banner" 
                                         class="max-w-full h-48 object-cover rounded-lg border-2 border-gray-200"
                                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                </div>
                                <div class="flex justify-center px-6 pt-5 pb-6 border-2 border-gray-300 border-dashed rounded-lg hover:border-primary transition cursor-pointer" onclick="document.getElementById('banner_image').click()">
                                    <div class="space-y-1 text-center">
                                        <svg class="mx-auto h-12 w-12 text-gray-400" stroke="currentColor" fill="none" viewBox="0 0 48 48">
                                            <path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28m0 0l4 4m4-24h8m-4-4v8m-12 4h.02" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                        <div class="flex text-sm text-gray-600">
                                            <label for="banner_image" class="relative cursor-pointer rounded-md font-medium text-primary hover:text-primary-dark">
                                                <span>Upload banner image</span>
                                                <input id="banner_image" name="banner_image" type="file" class="sr-only" accept="image/*" onchange="previewBannerImage(this)">
                                            </label>
                                            <p class="pl-1">or drag and drop</p>
                                        </div>
                                        <p class="text-xs text-gray-500">PNG, JPG, GIF, WEBP up to 5MB</p>
                                    </div>
                                </div>
                                <div id="banner-image-preview" class="mt-4 hidden">
                                    <p class="text-sm text-gray-600 mb-2">New Image Preview:</p>
                                    <img id="banner-preview" src="" alt="Preview" class="max-w-full h-48 object-cover rounded-lg border-2 border-gray-200">
                                    <button type="button" onclick="removeBannerImage()" class="mt-2 text-sm text-red-600 hover:text-red-800">Remove new image</button>
                                </div>
                            </div>
                            
                            <!-- Banner Title -->
                            <div>
                                <label for="banner_title" class="block text-sm font-semibold text-gray-700 mb-2">
                                    Banner Title
                                </label>
                                <input type="text" name="banner_title" id="banner_title" value=""
                                       placeholder="e.g., Premium Fashion"
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                            </div>
                            
                            <!-- Banner Subtitle -->
                            <div>
                                <label for="banner_subtitle" class="block text-sm font-semibold text-gray-700 mb-2">
                                    Banner Subtitle/Badge
                                </label>
                                <input type="text" name="banner_subtitle" id="banner_subtitle" value=""
                                       placeholder="e.g., ⭐ FEATURED COLLECTION"
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                            </div>
                            
                            <!-- Banner Description -->
                            <div class="md:col-span-2">
                                <label for="banner_description" class="block text-sm font-semibold text-gray-700 mb-2">
                                    Banner Description
                                </label>
                                <textarea name="banner_description" id="banner_description" rows="3"
                                          placeholder="e.g., Discover our handpicked selection of the finest fashion items..."
                                          class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition resize-none"></textarea>
                            </div>
                            
                            <!-- Banner Link -->
                            <div class="md:col-span-2">
                                <label for="banner_link" class="block text-sm font-semibold text-gray-700 mb-2">
                                    Banner Link (Optional)
                                </label>
                                <input type="text" name="banner_link" id="banner_link" value=""
                                       placeholder="e.g., /products?featured=1 or leave empty for default"
                                       class="w-full px-4 py-3 border-2 border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition">
                                <p class="mt-2 text-sm text-gray-500">Leave empty to use default link</p>
                            </div>
                        </div>
                        
                        <div class="mt-6 flex justify-end space-x-3">
                            <button type="button" onclick="closeBannerForm()" class="px-6 py-3 border-2 border-gray-300 text-gray-700 rounded-lg font-semibold hover:bg-gray-50 transition">
                                Cancel
                            </button>
                            <button type="submit" class="px-6 py-3 bg-primary text-white rounded-lg font-semibold hover:bg-primary-dark transition shadow-md hover:shadow-lg">
                                Save Banner Settings
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Tab switching functionality
function switchTab(tabName) {
    // Hide all tab contents
    document.querySelectorAll('.tab-content').forEach(content => {
        content.classList.add('hidden');
    });
    
    // Remove active state from all tabs
    document.querySelectorAll('.tab-button').forEach(button => {
        button.classList.remove('border-primary', 'text-primary');
        button.classList.add('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
    });
    
    // Show selected tab content
    document.getElementById('content-' + tabName).classList.remove('hidden');
    
    // Add active state to selected tab
    const activeTab = document.getElementById('tab-' + tabName);
    activeTab.classList.remove('border-transparent', 'text-gray-500', 'hover:text-gray-700', 'hover:border-gray-300');
    activeTab.classList.add('border-primary', 'text-primary');
}

// Initialize with sliders tab active
document.addEventListener('DOMContentLoaded', function() {
    switchTab('sliders');
});

function previewBannerImage(input) {
    const preview = document.getElementById('banner-preview');
    const previewContainer = document.getElementById('banner-image-preview');
    
    if (input.files && input.files[0]) {
        const reader = new FileReader();
        
        reader.onload = function(e) {
            preview.src = e.target.result;
            previewContainer.classList.remove('hidden');
        }
        
        reader.readAsDataURL(input.files[0]);
    }
}

function removeBannerImage() {
    const input = document.getElementById('banner_image');
    const previewContainer = document.getElementById('banner-image-preview');
    
    input.value = '';
    previewContainer.classList.add('hidden');
}

// Banner data from PHP
const bannerData = {
    'featured': {
        title: 'Featured Products Banner',
        image: @json($bannerSettings['featured']['banner_image']),
        banner_title: @json($bannerSettings['featured']['banner_title'] ?? ''),
        banner_subtitle: @json($bannerSettings['featured']['banner_subtitle'] ?? ''),
        banner_description: @json($bannerSettings['featured']['banner_description'] ?? ''),
        banner_link: @json($bannerSettings['featured']['banner_link'] ?? ''),
    },
    'shop_for_her': {
        title: "Left Collection Banner",
        image: @json($bannerSettings['shop_for_her']['banner_image']),
        banner_title: @json($bannerSettings['shop_for_her']['banner_title'] ?? ''),
        banner_subtitle: @json($bannerSettings['shop_for_her']['banner_subtitle'] ?? ''),
        banner_description: @json($bannerSettings['shop_for_her']['banner_description'] ?? ''),
        banner_link: @json($bannerSettings['shop_for_her']['banner_link'] ?? ''),
    },
    'shop_for_him': {
        title: "Right Collection Banner",
        image: @json($bannerSettings['shop_for_him']['banner_image']),
        banner_title: @json($bannerSettings['shop_for_him']['banner_title'] ?? ''),
        banner_subtitle: @json($bannerSettings['shop_for_him']['banner_subtitle'] ?? ''),
        banner_description: @json($bannerSettings['shop_for_him']['banner_description'] ?? ''),
        banner_link: @json($bannerSettings['shop_for_him']['banner_link'] ?? ''),
    },
    'trending': {
        title: "Trending Banner",
        image: @json($bannerSettings['trending']['banner_image']),
        banner_title: @json($bannerSettings['trending']['banner_title'] ?? ''),
        banner_subtitle: @json($bannerSettings['trending']['banner_subtitle'] ?? ''),
        banner_description: @json($bannerSettings['trending']['banner_description'] ?? ''),
        banner_link: @json($bannerSettings['trending']['banner_link'] ?? ''),
    }
};

// Banner form management
function openBannerForm(bannerType) {
    const bannerList = document.getElementById('banner-list');
    const bannerForm = document.getElementById('banner-form-container');
    const bannerDataForType = bannerData[bannerType];
    
    if (!bannerDataForType) {
        console.error('Invalid banner type:', bannerType);
        return;
    }
    
    // Hide banner list
    bannerList.classList.add('hidden');
    
    // Show banner form
    bannerForm.classList.remove('hidden');
    
    // Set banner type
    document.getElementById('banner_type').value = bannerType;
    
    // Update form title
    document.getElementById('banner-form-title').textContent = bannerDataForType.title;
    
    // Populate form fields
    document.getElementById('banner_title').value = bannerDataForType.banner_title || '';
    document.getElementById('banner_subtitle').value = bannerDataForType.banner_subtitle || '';
    document.getElementById('banner_description').value = bannerDataForType.banner_description || '';
    document.getElementById('banner_link').value = bannerDataForType.banner_link || '';
    
    // Update current image display
    const currentImageContainer = document.getElementById('current-banner-image-container');
    const currentImage = document.getElementById('current-banner-image');
    if (bannerDataForType.image) {
        // bannerDataForType.image is already a full URL from PHP (productImageUrl)
        currentImage.src = bannerDataForType.image;
        currentImageContainer.classList.remove('hidden');
    } else {
        currentImageContainer.classList.add('hidden');
    }
    
    // Reset preview
    document.getElementById('banner-image-preview').classList.add('hidden');
    document.getElementById('banner_image').value = '';
    
    // Scroll to form
    bannerForm.scrollIntoView({ behavior: 'smooth', block: 'start' });
}

function closeBannerForm() {
    const bannerList = document.getElementById('banner-list');
    const bannerForm = document.getElementById('banner-form-container');
    
    // Show banner list
    bannerList.classList.remove('hidden');
    
    // Hide banner form
    bannerForm.classList.add('hidden');
}
</script>
@endsection

