@extends('layouts.app')

@section('title', 'Manage Products - Admin')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">Manage Products</h1>
        <a href="{{ route('admin.products.create') }}" class="bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark transition">
            Create New Product
        </a>
    </div>

    @if(session('success'))
        <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-6 rounded" role="alert">
            <p>{{ session('success') }}</p>
        </div>
    @endif

    @if($products->count() > 0)
        <div class="bg-white shadow overflow-hidden sm:rounded-md">
            <ul class="divide-y divide-gray-200">
                @foreach($products as $product)
                    <li>
                        <div class="px-4 py-4 sm:px-6 flex items-center justify-between">
                            <div class="flex items-center space-x-4 flex-1">
                                <div class="flex-shrink-0">
                                    <img src="{{ productImageUrl($product->image) }}" 
                                         alt="{{ $product->name }}" 
                                         class="h-20 w-20 object-cover rounded"
                                         onerror="this.src='{{ url('images/placeholder.jpg') }}'; this.onerror=null;">
                                </div>
                                <div class="flex-1 min-w-0">
                                    <div class="flex items-center space-x-2">
                                        <p class="text-lg font-semibold text-gray-900">{{ $product->name }}</p>
                                        @if($product->is_active)
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                Active
                                            </span>
                                        @else
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                Inactive
                                            </span>
                                        @endif
                                        @if($product->is_featured)
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                                Featured
                                            </span>
                                        @endif
                                    </div>
                                    <p class="text-sm text-gray-500 mt-1">
                                        @if($product->categories->count() > 0)
                                            {{ $product->categories->pluck('name')->join(', ') }}
                                        @else
                                            {{ $product->category->name ?? 'No Category' }}
                                        @endif
                                    </p>
                                    <p class="text-sm text-gray-500">
                                        Price: {{ currency($product->price) }} | Stock: {{ $product->stock }}
                                        @if($product->on_sale)
                                            | <span class="text-primary font-semibold">ON SALE</span>
                                        @endif
                                    </p>
                                </div>
                            </div>
                            <div class="flex items-center space-x-2">
                                <a href="{{ route('admin.products.edit', $product) }}" class="text-primary hover:text-primary-dark">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                </a>
                                <form action="{{ route('admin.products.destroy', $product) }}" method="POST" class="inline" onsubmit="return confirm('Are you sure you want to delete this product?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:text-red-800">
                                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                        </svg>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </li>
                @endforeach
            </ul>
        </div>

        <div class="mt-6">
            {{ $products->links() }}
        </div>
    @else
        <div class="bg-white shadow rounded-lg p-8 text-center">
            <p class="text-gray-500 text-lg">No products found.</p>
            <a href="{{ route('admin.products.create') }}" class="mt-4 inline-block bg-primary text-white px-6 py-2 rounded hover:bg-primary-dark transition">
                Create Your First Product
            </a>
        </div>
    @endif
</div>
@endsection

