<?php

namespace Database\Seeders;

use App\Models\Slider;
use Illuminate\Database\Seeder;

class SliderSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $sliders = [
            [
                'title' => 'Welcome to Our Store',
                'subtitle' => 'Discover Amazing Products',
                'description' => 'Shop the latest trends and find everything you need in one place.',
                'price' => 0,
                'image' => 'sliders/slider-1.jpg',
                'link' => '/products',
                'order' => 1,
                'is_active' => true,
            ],
            [
                'title' => 'New Collection',
                'subtitle' => 'Fashion Forward',
                'description' => 'Explore our newest collection of stylish and trendy items.',
                'price' => 0,
                'image' => 'sliders/slider-2.jpg',
                'link' => '/products',
                'order' => 2,
                'is_active' => true,
            ],
            [
                'title' => 'Special Offers',
                'subtitle' => 'Limited Time Deals',
                'description' => 'Don\'t miss out on our exclusive offers and discounts.',
                'price' => 0,
                'image' => 'sliders/slider-3.jpg',
                'link' => '/products',
                'order' => 3,
                'is_active' => true,
            ],
        ];

        foreach ($sliders as $slider) {
            Slider::create($slider);
        }
    }
}
