<?php

namespace Database\Seeders;

use App\Models\Product;
use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class ProductSeeder extends Seeder
{
    public function run()
    {
        $categories = Category::all();

        if ($categories->isEmpty()) {
            $this->command->warn('No categories found. Please run CategorySeeder first.');
            return;
        }

        $products = [
            [
                'name' => 'Elegant Summer Dress',
                'slug' => 'elegant-summer-dress',
                'description' => 'A beautiful and elegant summer dress perfect for any occasion. Made from high-quality fabric with a comfortable fit.',
                'short_description' => 'Perfect summer dress for any occasion',
                'price' => 89.99,
                'compare_price' => 129.99,
                'sku' => 'WOM-DRESS-001',
                'image' => 'products/dress-1.jpg',
                'size' => 'M',
                'color' => 'Blue',
                'brand' => 'Fashion Brand',
                'stock' => 50,
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'name' => 'Classic White Shirt',
                'slug' => 'classic-white-shirt',
                'description' => 'A timeless classic white shirt that never goes out of style. Perfect for both casual and formal occasions.',
                'short_description' => 'Timeless classic white shirt',
                'price' => 49.99,
                'compare_price' => 69.99,
                'sku' => 'MEN-SHIRT-001',
                'image' => 'products/shirt-1.jpg',
                'size' => 'L',
                'color' => 'White',
                'brand' => 'Fashion Brand',
                'stock' => 75,
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'name' => 'Designer Handbag',
                'slug' => 'designer-handbag',
                'description' => 'A luxurious designer handbag made from premium leather. Spacious and stylish, perfect for everyday use.',
                'short_description' => 'Luxurious designer handbag',
                'price' => 199.99,
                'compare_price' => 299.99,
                'sku' => 'BAG-001',
                'image' => 'products/bag-1.jpg',
                'size' => null,
                'color' => 'Black',
                'brand' => 'Luxury Brand',
                'stock' => 30,
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'name' => 'High Heel Shoes',
                'slug' => 'high-heel-shoes',
                'description' => 'Elegant high heel shoes that add sophistication to any outfit. Comfortable and stylish.',
                'short_description' => 'Elegant high heel shoes',
                'price' => 79.99,
                'compare_price' => 119.99,
                'sku' => 'SHOE-001',
                'image' => 'products/shoe-1.jpg',
                'size' => '38',
                'color' => 'Red',
                'brand' => 'Fashion Brand',
                'stock' => 40,
                'is_featured' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Leather Jacket',
                'slug' => 'leather-jacket',
                'description' => 'A stylish leather jacket that never goes out of fashion. Perfect for any season.',
                'short_description' => 'Stylish leather jacket',
                'price' => 149.99,
                'compare_price' => 199.99,
                'sku' => 'MEN-JACKET-001',
                'image' => 'products/jacket-1.jpg',
                'size' => 'XL',
                'color' => 'Black',
                'brand' => 'Fashion Brand',
                'stock' => 25,
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'name' => 'Silk Scarf',
                'slug' => 'silk-scarf',
                'description' => 'A beautiful silk scarf that adds elegance to any outfit. Made from premium silk.',
                'short_description' => 'Beautiful silk scarf',
                'price' => 39.99,
                'compare_price' => 59.99,
                'sku' => 'ACC-SCARF-001',
                'image' => 'products/scarf-1.jpg',
                'size' => null,
                'color' => 'Pink',
                'brand' => 'Fashion Brand',
                'stock' => 60,
                'is_featured' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Casual Jeans',
                'slug' => 'casual-jeans',
                'description' => 'Comfortable and stylish casual jeans perfect for everyday wear. Made from premium denim.',
                'short_description' => 'Comfortable casual jeans',
                'price' => 59.99,
                'compare_price' => 89.99,
                'sku' => 'MEN-JEANS-001',
                'image' => 'products/jeans-1.jpg',
                'size' => '32',
                'color' => 'Blue',
                'brand' => 'Fashion Brand',
                'stock' => 80,
                'is_featured' => false,
                'is_active' => true,
            ],
            [
                'name' => 'Evening Gown',
                'slug' => 'evening-gown',
                'description' => 'A stunning evening gown perfect for special occasions. Elegant and sophisticated.',
                'short_description' => 'Stunning evening gown',
                'price' => 249.99,
                'compare_price' => 349.99,
                'sku' => 'WOM-GOWN-001',
                'image' => 'products/gown-1.jpg',
                'size' => 'S',
                'color' => 'Black',
                'brand' => 'Luxury Brand',
                'stock' => 15,
                'is_featured' => true,
                'is_active' => true,
            ],
        ];

        foreach ($products as $index => $productData) {
            // Assign products to categories in a round-robin fashion
            $category = $categories[$index % $categories->count()];
            $productData['category_id'] = $category->id;
            Product::create($productData);
        }
    }
}
