<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Check if admin user already exists
        $admin = User::where('email', 'webdesignhut0@gmail.com')->first();
        
        if (!$admin) {
            // Create admin user
            User::create([
                'name' => 'Admin',
                'email' => 'webdesignhut0@gmail.com',
                'password' => Hash::make('3040064@Kbs...'),
                'is_admin' => true,
            ]);
            
            $this->command->info('Admin user created successfully!');
        } else {
            // Update existing user to be admin
            $admin->update([
                'password' => Hash::make('3040064@Kbs...'),
                'is_admin' => true,
            ]);
            
            $this->command->info('Admin user updated successfully!');
        }
    }
}
