<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdminNotificationPreference extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'browser_notifications_enabled',
        'sound_enabled',
        'new_order_notifications',
        'new_user_notifications',
        'last_checked_at',
    ];

    protected $casts = [
        'browser_notifications_enabled' => 'boolean',
        'sound_enabled' => 'boolean',
        'new_order_notifications' => 'boolean',
        'new_user_notifications' => 'boolean',
        'last_checked_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
