<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ToolController extends Controller
{
    public function index()
    {
        $store = Auth::user()->store;
        $tools = [
            [
                'name' => 'Marketing Campaign Planner',
                'description' => 'Plan and track your marketing campaigns.',
                'url' => '#',
            ],
            [
                'name' => 'Social Media Scheduler',
                'description' => 'Schedule your social media posts in advance.',
                'url' => '#',
            ],
            [
                'name' => 'SEO Analyzer',
                'description' => 'Analyze your store\'s SEO performance.',
                'url' => '#',
            ],
        ];
        return view('store.tools.index', compact('store', 'tools'));
    }
}
