<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use App\Models\ReturnRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ReturnController extends Controller
{
    public function index()
    {
        $store = Auth::user()->store;
        
        if (!$store) {
            return redirect()->route('store.register')
                ->with('error', 'Please complete your store registration.');
        }

        // Get return requests for products that belong to this store
        $storeProductIds = $store->products()->pluck('id');
        
        $returns = ReturnRequest::whereIn('product_id', $storeProductIds)
            ->orWhere('store_id', $store->id)
            ->with(['order', 'product', 'user', 'orderItem'])
            ->latest()
            ->paginate(20);
            
        return view('store.returns.index', compact('store', 'returns'));
    }
}
