<?php

namespace App\Http\Controllers\Store;

use App\Http\Controllers\Controller;
use App\Models\Quote;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RequestQuoteController extends Controller
{
    public function index()
    {
        $store = Auth::user()->store;
        $quotes = $store->quotes()->with('user', 'product')->latest()->paginate(10);
        return view('store.quotes.index', compact('store', 'quotes'));
    }

    public function reply(Request $request, Quote $quote)
    {
        $request->validate([
            'reply' => 'required|string',
        ]);

        if ($quote->store_id !== Auth::user()->store->id) {
            abort(403);
        }

        $quote->update([
            'reply' => $request->reply,
            'status' => 'replied',
        ]);

        return redirect()->route('store.request-quotes.index')->with('success', 'Reply sent successfully.');
    }
}
