<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class LocationController extends Controller
{
    public function setLocation(Request $request)
    {
        $validated = $request->validate([
            'location' => 'required|string|max:255',
            'city' => 'nullable|string|max:255',
            'state' => 'nullable|string|max:255',
            'country' => 'nullable|string|max:255',
            'route' => 'nullable|string|max:255',
            'latitude' => 'nullable|numeric',
            'longitude' => 'nullable|numeric',
        ]);

        // Determine display name: route (street) > city > state > location
        $displayName = $validated['route'] ?? $validated['city'] ?? $validated['state'] ?? $validated['location'];

        // Store location in session
        session([
            'selected_location' => $displayName,
            'location_city' => $validated['city'] ?? null,
            'location_state' => $validated['state'] ?? null,
            'location_country' => $validated['country'] ?? null,
            'location_route' => $validated['route'] ?? null,
            'location_latitude' => $validated['latitude'] ?? null,
            'location_longitude' => $validated['longitude'] ?? null,
        ]);

        return response()->json([
            'success' => true,
            'location' => $displayName,
            'message' => 'Location updated successfully'
        ]);
    }
}
