<?php

namespace App\Http\Controllers;

use App\Services\CurrencyService;
use Illuminate\Http\Request;

class CurrencyController extends Controller
{
    protected $currencyService;
    
    public function __construct(CurrencyService $currencyService)
    {
        $this->currencyService = $currencyService;
    }
    
    public function change(Request $request)
    {
        $currency = $request->input('currency');
        
        if ($this->currencyService->setCurrentCurrency($currency)) {
            return response()->json([
                'success' => true,
                'currency' => $currency,
                'message' => 'Currency changed successfully'
            ]);
        }
        
        return response()->json([
            'success' => false,
            'message' => 'Invalid currency'
        ], 400);
    }
}

