<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Store;
use Illuminate\Http\Request;

class ManualApprovalController extends Controller
{
    public function approveStore(Request $request)
    {
        $request->validate([
            'store_id' => 'required|exists:stores,id',
        ]);

        $store = Store::findOrFail($request->store_id);

        $store->update([
            'status' => 'approved',
            'approved_at' => now(),
            'rejection_reason' => null, // Clear any previous rejection reason
        ]);

        return redirect()->route('admin.stores.index')
            ->with('success', "Store '{$store->business_name}' approved successfully!");
    }

    public function rejectStore(Request $request)
    {
        $request->validate([
            'store_id' => 'required|exists:stores,id',
            'rejection_reason' => 'required|string|max:500',
        ]);

        $store = Store::findOrFail($request->store_id);

        $store->update([
            'status' => 'rejected',
            'rejection_reason' => $request->rejection_reason,
            'approved_at' => null,
        ]);

        return redirect()->route('admin.stores.index')
            ->with('success', "Store '{$store->business_name}' rejected.");
    }

    public function suspendStore(Request $request)
    {
        $request->validate([
            'store_id' => 'required|exists:stores,id',
            'rejection_reason' => 'nullable|string|max:500',
        ]);

        $store = Store::findOrFail($request->store_id);

        $store->update([
            'status' => 'suspended',
            'rejection_reason' => $request->rejection_reason ?? 'Store suspended by administrator',
        ]);

        return redirect()->route('admin.stores.index')
            ->with('success', "Store '{$store->business_name}' suspended.");
    }

    public function unsuspendStore(Request $request)
    {
        $request->validate([
            'store_id' => 'required|exists:stores,id',
        ]);

        $store = Store::findOrFail($request->store_id);

        $store->update([
            'status' => 'approved',
            'rejection_reason' => null,
        ]);

        return redirect()->route('admin.stores.index')
            ->with('success', "Store '{$store->business_name}' unsuspended and approved.");
    }
}
