<?php

use Illuminate\Support\Facades\Storage;

if (!function_exists('productImageUrl')) {
    /**
     * Get the correct URL for any image (products, sliders, banners, categories, settings)
     * Simple version that just uses Storage::url() - matches working project approach
     */
    function productImageUrl($imagePath)
    {
        if (empty($imagePath)) {
            return asset('images/placeholder.jpg');
        }
        
        // If it's already an external URL, return as is
        if (strpos($imagePath, 'http') === 0) {
            return $imagePath;
        }
        
        // Clean path - remove any leading slashes or prefixes
        $cleanPath = ltrim($imagePath, '/');
        $cleanPath = str_replace(['public/storage/', '/public/storage/', 'storage/', '/storage/'], '', $cleanPath);
        
        // Use Storage::url() directly - it handles APP_URL automatically
        return Storage::disk('public')->url($cleanPath);
    }
}

// Alias for backward compatibility and clarity
if (!function_exists('imageUrl')) {
    function imageUrl($imagePath)
    {
        return productImageUrl($imagePath);
    }
}


