<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;

class MakeUserAdmin extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'user:make-admin {email}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Convert a user account to admin with all permissions';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $email = $this->argument('email');
        
        $user = User::where('email', $email)->first();
        
        if (!$user) {
            $this->error("User with email '{$email}' not found.");
            return Command::FAILURE;
        }
        
        $user->update([
            'is_admin' => true,
            'can_manage_products' => true,
            'can_manage_orders' => true,
            'can_manage_users' => true,
            'can_manage_categories' => true,
            'can_manage_sliders' => true,
            'can_view_analytics' => true,
            'can_manage_settings' => true,
        ]);
        
        $this->info("Successfully converted user '{$user->name}' ({$email}) to admin with all permissions!");
        
        return Command::SUCCESS;
    }
}
