<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Category;
use Illuminate\Support\Str;

class CreateCategories extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'categories:create';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Create default categories';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $categories = [
            'Electronics',
            'Home Appliances',
            'Furniture',
            'Fashion',
            'Jobs & Services',
            'Vehicles',
            'Property',
            'Beauty',
            'Games',
        ];

        $created = 0;
        $skipped = 0;

        foreach ($categories as $categoryName) {
            $slug = Str::slug($categoryName);
            
            // Check if category already exists
            $existing = Category::where('slug', $slug)->first();
            
            if ($existing) {
                $this->warn("Category '{$categoryName}' already exists. Skipping...");
                $skipped++;
                continue;
            }

            Category::create([
                'name' => $categoryName,
                'slug' => $slug,
                'description' => "Browse our {$categoryName} collection",
                'is_active' => true,
            ]);

            $this->info("Created category: {$categoryName}");
            $created++;
        }

        $this->newLine();
        $this->info("Categories creation completed!");
        $this->info("Created: {$created} categories");
        if ($skipped > 0) {
            $this->warn("Skipped: {$skipped} categories (already exist)");
        }

        return Command::SUCCESS;
    }
}
