# WAMP Setup Instructions

## If `http://localhost/VV` gives 404 but `http://localhost/VV/public` works:

### Option 1: Update Apache Virtual Host (Recommended)

1. Open WAMP menu → Apache → httpd-vhosts.conf
2. Add this configuration:

```apache
<VirtualHost *:80>
    DocumentRoot "C:/wamp64/www/VV/public"
    ServerName localhost
    <Directory "C:/wamp64/www/VV/public">
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

3. Restart Apache
4. Access via: `http://localhost/VV` (should work now)

### Option 2: Use the public folder directly

If the `.htaccess` redirect isn't working, you can:
- Access the site via: `http://localhost/VV/public`
- Update your `.env` file:
  ```
  APP_URL=http://localhost/VV/public
  ```

### Option 3: Check Apache AllowOverride

1. Open WAMP menu → Apache → httpd.conf
2. Find the section for your document root
3. Make sure it has: `AllowOverride All`
4. Restart Apache

### Option 4: Create a Virtual Host

1. Open WAMP menu → Apache → httpd-vhosts.conf
2. Add:

```apache
<VirtualHost *:80>
    DocumentRoot "C:/wamp64/www/VV/public"
    ServerName vv.local
    <Directory "C:/wamp64/www/VV/public">
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

3. Edit `C:\Windows\System32\drivers\etc\hosts` (as Administrator)
4. Add: `127.0.0.1 vv.local`
5. Restart Apache
6. Access via: `http://vv.local`

