# Quick Fix for Images Not Loading

## If NO images are working after deployment:

### Step 1: Regenerate Autoload Files
```bash
composer dump-autoload
```

### Step 2: Clear All Caches
```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
php artisan optimize:clear
```

### Step 3: Create Storage Link
```bash
# Remove existing link if broken
rm -rf public/storage

# Create new link
php artisan storage:link

# Verify it exists
ls -la public/storage
```

### Step 4: Check .env File
Make sure your `.env` has:
```env
APP_URL=https://vibrantvogue.shop
```

Then run:
```bash
php artisan config:cache
```

### Step 5: Run Diagnostic Script
```bash
php DIAGNOSE_IMAGES.php
```

This will tell you exactly what's wrong.

### Step 6: Check Permissions
```bash
chmod -R 775 storage
chmod -R 775 public/storage
chown -R $(whoami):$(whoami) storage public/storage
```

### Step 7: Test Direct Image Access
Try accessing an image directly in browser:
```
https://vibrantvogue.shop/storage/products/[actual-image-filename]
```

If this works → The symlink is fine, issue is in code
If this doesn't work → The symlink or permissions are the problem

## Common Issues:

### Issue 1: Helper Function Not Loaded
**Symptom**: Images show as broken, no errors
**Fix**: 
```bash
composer dump-autoload
php artisan config:clear
```

### Issue 2: Storage Link Not Created
**Symptom**: Direct image URLs return 404
**Fix**:
```bash
rm -rf public/storage
php artisan storage:link
```

### Issue 3: APP_URL Not Set
**Symptom**: Images use localhost URLs
**Fix**: Set `APP_URL=https://vibrantvogue.shop` in `.env` and run `php artisan config:cache`

### Issue 4: Permissions
**Symptom**: 403 Forbidden errors
**Fix**:
```bash
chmod -R 775 storage public/storage
```

## After Fixing:

1. Clear browser cache
2. Test a few images
3. Check browser console for 404 errors
4. Verify image URLs in page source

