#!/bin/bash
# Fix Storage Permissions and Create Missing Directories
# Run this on your server via SSH

cd /home/vendymal/vibrantvogue.shop

echo "=== Creating Storage Directories ==="

# Create all necessary storage directories
mkdir -p storage/framework/sessions
mkdir -p storage/framework/views
mkdir -p storage/framework/cache
mkdir -p storage/framework/cache/data
mkdir -p storage/app/public/products
mkdir -p storage/app/public/categories
mkdir -p storage/app/public/sliders
mkdir -p storage/app/public/banners
mkdir -p storage/app/public/settings
mkdir -p storage/logs
mkdir -p bootstrap/cache

echo "=== Setting Permissions ==="

# Set proper permissions (775 for directories, 664 for files)
chmod -R 775 storage
chmod -R 775 bootstrap/cache

# Set ownership (adjust user:group if needed)
chown -R vendymal:vendymal storage
chown -R vendymal:vendymal bootstrap/cache

echo "=== Verifying Storage Symlink ==="

# Remove existing symlink if it's wrong
if [ -L public/storage ]; then
    echo "Removing existing symlink..."
    rm public/storage
fi

# Create correct symlink (public/storage -> storage/app/public)
if [ ! -e public/storage ]; then
    echo "Creating storage symlink..."
    ln -s ../storage/app/public public/storage
    echo "✅ Symlink created: public/storage -> storage/app/public"
else
    echo "⚠️  public/storage already exists (may be a directory, not symlink)"
fi

echo ""
echo "=== Verification ==="
echo "Storage directories:"
ls -la storage/framework/
echo ""
echo "Storage symlink:"
ls -la public/storage

echo ""
echo "✅ Done! Storage directories and permissions are now set correctly."

