# Fix Storage Permissions - Quick Guide

## The Problem
Laravel is trying to write session files to `/home/vendymal/vibrantvogue.shop/public/storage/framework/sessions/` but this directory doesn't exist or has wrong permissions.

**Important:** Sessions should be in `storage/framework/sessions/` (project root), NOT in `public/storage/framework/sessions/`.

## The Solution

Run these commands on your server via SSH:

```bash
cd /home/vendymal/vibrantvogue.shop

# Create all necessary storage directories
mkdir -p storage/framework/sessions
mkdir -p storage/framework/views
mkdir -p storage/framework/cache
mkdir -p storage/framework/cache/data
mkdir -p storage/app/public/products
mkdir -p storage/app/public/categories
mkdir -p storage/app/public/sliders
mkdir -p storage/app/public/banners
mkdir -p storage/app/public/settings
mkdir -p storage/logs
mkdir -p bootstrap/cache

# Set proper permissions
chmod -R 775 storage
chmod -R 775 bootstrap/cache

# Set ownership (adjust if your user/group is different)
chown -R vendymal:vendymal storage
chown -R vendymal:vendymal bootstrap/cache

# Verify and fix storage symlink
# Remove wrong symlink if it exists
rm -f public/storage

# Create correct symlink (public/storage -> storage/app/public)
ln -s ../storage/app/public public/storage

# Verify it worked
ls -la public/storage
# Should show: public/storage -> ../storage/app/public
```

## Or Use the Script

I've created a script `FIX_STORAGE_PERMISSIONS.sh` that does all of this automatically. Upload it to your server and run:

```bash
chmod +x FIX_STORAGE_PERMISSIONS.sh
./FIX_STORAGE_PERMISSIONS.sh
```

## After Running

Clear Laravel caches:
```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

Then refresh your website. The session error should be gone!

