# Final Fix for Production - Images Not Working

## Files to Upload

Upload ONLY these files:
1. `app/Helpers/ImageHelper.php` ✅ (Updated helper)

That's it! Just one file.

## Commands to Run on Server

```bash
# 1. Set proper permissions (IMPORTANT!)
chmod -R 755 storage
chmod -R 755 bootstrap/cache
chmod -R 755 public
chmod -R 755 public/storage

# 2. Make sure storage directories exist
mkdir -p storage/framework/sessions
mkdir -p storage/framework/views
mkdir -p storage/framework/cache
mkdir -p storage/app/public/products
mkdir -p storage/app/public/categories
mkdir -p storage/app/public/sliders
mkdir -p storage/app/public/banners
mkdir -p storage/app/public/settings
mkdir -p storage/logs
mkdir -p bootstrap/cache

# 3. Set ownership (replace 'vendymal' with your username if different)
chown -R vendymal:vendymal storage
chown -R vendymal:vendymal bootstrap/cache
chown -R vendymal:vendymal public/storage

# 4. Regenerate autoload (CRITICAL!)
composer dump-autoload

# 5. Clear ALL caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
php artisan optimize:clear

# 6. Check .env file
# Make sure it has: APP_URL=https://vibrantvogue.shop
# NO trailing slash!

# 7. Cache config
php artisan config:cache

# 8. Verify storage link
ls -la public/storage
# Should show: public/storage -> ../storage/app/public

# 9. If link is broken, recreate it
rm -rf public/storage
php artisan storage:link
```

## Test Direct Image Access

After running commands, test in browser:
```
https://vibrantvogue.shop/storage/products/9azZ8rSWwD5OIXAgCi0rc3UCgbqj4Nl7Jz49PBKG.jpg
```

Replace with an actual filename from:
```bash
ls storage/app/public/products/ | head -1
```

## If Still Not Working - Diagnostic

Run this to see what's happening:
```bash
php artisan tinker --execute="echo 'APP_URL: ' . config('app.url') . PHP_EOL; echo 'Test URL: ' . productImageUrl('products/test.jpg') . PHP_EOL; \$p = App\Models\Product::whereNotNull('image')->first(); if(\$p) { echo 'Real Product URL: ' . productImageUrl(\$p->image) . PHP_EOL; }"
```

Share the output if images still don't work.

## Permissions Summary

```bash
# Directories
chmod 755 storage
chmod 755 bootstrap/cache
chmod 755 public
chmod 755 public/storage

# Files inside
find storage -type f -exec chmod 644 {} \;
find storage -type d -exec chmod 755 {} \;
find bootstrap/cache -type f -exec chmod 644 {} \;
find bootstrap/cache -type d -exec chmod 755 {} \;
```

## Quick One-Liner Fix

```bash
cd /home/vendymal/vibrantvogue.shop && \
chmod -R 755 storage bootstrap/cache public && \
chown -R vendymal:vendymal storage bootstrap/cache public/storage && \
composer dump-autoload && \
php artisan config:clear && \
php artisan cache:clear && \
php artisan view:clear && \
php artisan config:cache && \
ls -la public/storage
```

