# Deployment Commands for Production

Run these commands in order after uploading your files to the server:

## 1. Install Dependencies
```bash
composer install --no-dev --optimize-autoloader
```

## 2. Environment Setup
```bash
# Copy .env.example to .env (if not already done)
cp .env.example .env

# IMPORTANT: Update APP_URL in .env file
# Edit .env and set:
# APP_URL=https://vibrantvogue.shop
# (or http://vibrantvogue.shop if not using SSL)

# Generate application key (if not already set)
php artisan key:generate
```

## 3. Database Migration
```bash
# Run migrations
php artisan migrate --force
```

## 4. Clear All Caches
```bash
# Clear configuration cache
php artisan config:clear

# Clear route cache
php artisan route:clear

# Clear view cache
php artisan view:clear

# Clear application cache
php artisan cache:clear
```

## 5. Optimize for Production
```bash
# Cache configuration (recommended for production)
php artisan config:cache

# Cache routes (recommended for production)
php artisan route:cache

# Cache views (recommended for production)
php artisan view:cache

# Optimize autoloader
composer dump-autoload --optimize
```

## 6. Create Storage Directories (IMPORTANT - Fixes session errors)
```bash
# Create all necessary storage directories
mkdir -p storage/framework/sessions
mkdir -p storage/framework/views
mkdir -p storage/framework/cache
mkdir -p storage/app/public
mkdir -p storage/logs
mkdir -p bootstrap/cache
```

## 7. Set Permissions (Linux/Unix servers)
```bash
# Set storage and cache permissions
chmod -R 775 storage bootstrap/cache
chown -R www-data:www-data storage bootstrap/cache

# Or if using different user (replace with your actual user):
# chown -R vendymal:vendymal storage bootstrap/cache
# Or if using cPanel/Shared hosting:
# chown -R $(whoami):$(whoami) storage bootstrap/cache
```

## 7. Link Storage (if using public storage)
```bash
php artisan storage:link
```

## 8. Fix Image Paths (if images are not loading)
If images are stored with `/public/storage/` paths in database but not loading:

```bash
# Check if storage link exists
ls -la public/storage

# If link doesn't exist or is broken, remove and recreate
rm public/storage
php artisan storage:link

# Verify the link points to correct location
ls -la public/storage

# Set proper permissions on storage directory
chmod -R 775 storage
chown -R www-data:www-data storage
```

## 9. Troubleshooting Image Issues

### Check if images exist:
```bash
# Check if product images exist in storage
ls -la storage/app/public/products/

# Check if symlink is correct
ls -la public/storage
```

### Common Issues:
1. **Images stored with `/public/storage/` path**: The helper function now converts this to `/storage/` automatically
2. **Permission issues**: Make sure `storage` and `public/storage` are writable
3. **Symlink not working**: Remove and recreate the symlink
4. **Web server not following symlinks**: Check Apache/Nginx configuration

## Quick All-in-One Command (after initial setup)
```bash
php artisan migrate --force && \
php artisan config:cache && \
php artisan route:cache && \
php artisan view:cache && \
composer dump-autoload --optimize
```

## Important Notes:
- Make sure your `.env` file has correct database credentials
- Make sure your `.env` file has `APP_ENV=production` and `APP_DEBUG=false`
- Ensure your web server (Apache/Nginx) points to the `public` directory
- Check that `storage` and `bootstrap/cache` directories are writable

