<?php
/**
 * Quick .htaccess Checker
 * Upload to server root and visit: https://vibrantvogue.shop/CHECK_HTACCESS.php
 */

$htaccessPath = __DIR__ . '/public/.htaccess';

echo "<h1>.htaccess Checker</h1>";
echo "<style>body{font-family:monospace;padding:20px;} .ok{color:green;} .error{color:red;} pre{background:#f5f5f5;padding:10px;border:1px solid #ddd;}</style>";

if (!file_exists($htaccessPath)) {
    echo "<p class='error'>✗ .htaccess file NOT FOUND at: {$htaccessPath}</p>";
    exit;
}

echo "<p class='ok'>✓ .htaccess file exists</p>";

$content = file_get_contents($htaccessPath);

echo "<h2>File Contents:</h2>";
echo "<pre>" . htmlspecialchars($content) . "</pre>";

echo "<h2>Checks:</h2>";

// Check 1: FollowSymLinks
if (strpos($content, 'FollowSymLinks') !== false) {
    echo "<p class='ok'>✓ FollowSymLinks found</p>";
} else {
    echo "<p class='error'>✗ FollowSymLinks NOT found!</p>";
}

// Check 2: Storage exclusion rule
if (strpos($content, 'RewriteCond %{REQUEST_URI} ^/storage/') !== false) {
    echo "<p class='ok'>✓ Storage exclusion rule found</p>";
} else {
    echo "<p class='error'>✗ Storage exclusion rule NOT found!</p>";
    echo "<p>Looking for: <code>RewriteCond %{REQUEST_URI} ^/storage/</code></p>";
}

// Check 3: Storage RewriteRule
if (strpos($content, 'RewriteRule ^ - [L]') !== false && strpos($content, 'storage') !== false) {
    echo "<p class='ok'>✓ Storage RewriteRule found</p>";
} else {
    echo "<p class='error'>✗ Storage RewriteRule NOT found!</p>";
}

echo "<hr>";
echo "<h2>What to do:</h2>";
echo "<p>If any checks failed, upload the correct <code>public/.htaccess</code> file from your local project to the server.</p>";

